package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	kubeSystemSecretEtcdSignerFileName = "kube-system-secret-etcd-signer.yaml.template"
)

var _ asset.WritableAsset = (*KubeSystemSecretEtcdSigner)(nil)

// KubeSystemSecretEtcdSigner is the constant to represent contents of kube-system-secret-etcd-signer.yaml.template file.
type KubeSystemSecretEtcdSigner struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *KubeSystemSecretEtcdSigner) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *KubeSystemSecretEtcdSigner) Name() string {
	return "KubeSystemSecretEtcdSigner"
}

// Generate generates the actual files by this asset
func (t *KubeSystemSecretEtcdSigner) Generate(parents asset.Parents) error {
	fileName := kubeSystemSecretEtcdSignerFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *KubeSystemSecretEtcdSigner) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *KubeSystemSecretEtcdSigner) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, kubeSystemSecretEtcdSignerFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
