// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PVMInstanceMultiCreate p VM instance multi create
// swagger:model PVMInstanceMultiCreate
type PVMInstanceMultiCreate struct {

	// Affinity policy for pvm-instances being created; affinity for the same host, anti-affinity for different hosts, none for no preference
	// Enum: [affinity anti-affinity none]
	AffinityPolicy *string `json:"affinityPolicy,omitempty"`

	// Number of pvm-instances to create
	Count int64 `json:"count,omitempty"`

	// Where to place the numerical number of the multi-created instance
	// Enum: [prefix suffix]
	Numerical *string `json:"numerical,omitempty"`
}

// Validate validates this p VM instance multi create
func (m *PVMInstanceMultiCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAffinityPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNumerical(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var pVmInstanceMultiCreateTypeAffinityPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["affinity","anti-affinity","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		pVmInstanceMultiCreateTypeAffinityPolicyPropEnum = append(pVmInstanceMultiCreateTypeAffinityPolicyPropEnum, v)
	}
}

const (

	// PVMInstanceMultiCreateAffinityPolicyAffinity captures enum value "affinity"
	PVMInstanceMultiCreateAffinityPolicyAffinity string = "affinity"

	// PVMInstanceMultiCreateAffinityPolicyAntiAffinity captures enum value "anti-affinity"
	PVMInstanceMultiCreateAffinityPolicyAntiAffinity string = "anti-affinity"

	// PVMInstanceMultiCreateAffinityPolicyNone captures enum value "none"
	PVMInstanceMultiCreateAffinityPolicyNone string = "none"
)

// prop value enum
func (m *PVMInstanceMultiCreate) validateAffinityPolicyEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, pVmInstanceMultiCreateTypeAffinityPolicyPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *PVMInstanceMultiCreate) validateAffinityPolicy(formats strfmt.Registry) error {

	if swag.IsZero(m.AffinityPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateAffinityPolicyEnum("affinityPolicy", "body", *m.AffinityPolicy); err != nil {
		return err
	}

	return nil
}

var pVmInstanceMultiCreateTypeNumericalPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["prefix","suffix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		pVmInstanceMultiCreateTypeNumericalPropEnum = append(pVmInstanceMultiCreateTypeNumericalPropEnum, v)
	}
}

const (

	// PVMInstanceMultiCreateNumericalPrefix captures enum value "prefix"
	PVMInstanceMultiCreateNumericalPrefix string = "prefix"

	// PVMInstanceMultiCreateNumericalSuffix captures enum value "suffix"
	PVMInstanceMultiCreateNumericalSuffix string = "suffix"
)

// prop value enum
func (m *PVMInstanceMultiCreate) validateNumericalEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, pVmInstanceMultiCreateTypeNumericalPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *PVMInstanceMultiCreate) validateNumerical(formats strfmt.Registry) error {

	if swag.IsZero(m.Numerical) { // not required
		return nil
	}

	// value enum
	if err := m.validateNumericalEnum("numerical", "body", *m.Numerical); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PVMInstanceMultiCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PVMInstanceMultiCreate) UnmarshalBinary(b []byte) error {
	var res PVMInstanceMultiCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
