// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// ServiceInstanceUpdateReader is a Reader for the ServiceInstanceUpdate structure.
type ServiceInstanceUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServiceInstanceUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewServiceInstanceUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 202:
		result := NewServiceInstanceUpdateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewServiceInstanceUpdateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 422:
		result := NewServiceInstanceUpdateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewServiceInstanceUpdateOK creates a ServiceInstanceUpdateOK with default headers values
func NewServiceInstanceUpdateOK() *ServiceInstanceUpdateOK {
	return &ServiceInstanceUpdateOK{}
}

/*ServiceInstanceUpdateOK handles this case with default header values.

OK
*/
type ServiceInstanceUpdateOK struct {
	Payload models.Object
}

func (o *ServiceInstanceUpdateOK) Error() string {
	return fmt.Sprintf("[PATCH /v2/service_instances/{instance_id}][%d] serviceInstanceUpdateOK  %+v", 200, o.Payload)
}

func (o *ServiceInstanceUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceInstanceUpdateAccepted creates a ServiceInstanceUpdateAccepted with default headers values
func NewServiceInstanceUpdateAccepted() *ServiceInstanceUpdateAccepted {
	return &ServiceInstanceUpdateAccepted{}
}

/*ServiceInstanceUpdateAccepted handles this case with default header values.

Accepted
*/
type ServiceInstanceUpdateAccepted struct {
	Payload *models.ServiceInstanceAsyncOperation
}

func (o *ServiceInstanceUpdateAccepted) Error() string {
	return fmt.Sprintf("[PATCH /v2/service_instances/{instance_id}][%d] serviceInstanceUpdateAccepted  %+v", 202, o.Payload)
}

func (o *ServiceInstanceUpdateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ServiceInstanceAsyncOperation)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceInstanceUpdateBadRequest creates a ServiceInstanceUpdateBadRequest with default headers values
func NewServiceInstanceUpdateBadRequest() *ServiceInstanceUpdateBadRequest {
	return &ServiceInstanceUpdateBadRequest{}
}

/*ServiceInstanceUpdateBadRequest handles this case with default header values.

Bad Request
*/
type ServiceInstanceUpdateBadRequest struct {
	Payload *models.Error
}

func (o *ServiceInstanceUpdateBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /v2/service_instances/{instance_id}][%d] serviceInstanceUpdateBadRequest  %+v", 400, o.Payload)
}

func (o *ServiceInstanceUpdateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceInstanceUpdateUnprocessableEntity creates a ServiceInstanceUpdateUnprocessableEntity with default headers values
func NewServiceInstanceUpdateUnprocessableEntity() *ServiceInstanceUpdateUnprocessableEntity {
	return &ServiceInstanceUpdateUnprocessableEntity{}
}

/*ServiceInstanceUpdateUnprocessableEntity handles this case with default header values.

Unprocessable entity
*/
type ServiceInstanceUpdateUnprocessableEntity struct {
	Payload *models.Error
}

func (o *ServiceInstanceUpdateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PATCH /v2/service_instances/{instance_id}][%d] serviceInstanceUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ServiceInstanceUpdateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
