// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/retail/v2/search_service.proto

package retail

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	_ "google.golang.org/protobuf/types/known/timestamppb"
	_ "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum to control DynamicFacet mode
type SearchRequest_DynamicFacetSpec_Mode int32

const (
	// Default value.
	SearchRequest_DynamicFacetSpec_MODE_UNSPECIFIED SearchRequest_DynamicFacetSpec_Mode = 0
	// Disable Dynamic Facet.
	SearchRequest_DynamicFacetSpec_DISABLED SearchRequest_DynamicFacetSpec_Mode = 1
	// Automatic mode built by Google Retail Search.
	SearchRequest_DynamicFacetSpec_ENABLED SearchRequest_DynamicFacetSpec_Mode = 2
)

// Enum value maps for SearchRequest_DynamicFacetSpec_Mode.
var (
	SearchRequest_DynamicFacetSpec_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
	}
	SearchRequest_DynamicFacetSpec_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"DISABLED":         1,
		"ENABLED":          2,
	}
)

func (x SearchRequest_DynamicFacetSpec_Mode) Enum() *SearchRequest_DynamicFacetSpec_Mode {
	p := new(SearchRequest_DynamicFacetSpec_Mode)
	*p = x
	return p
}

func (x SearchRequest_DynamicFacetSpec_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_DynamicFacetSpec_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_search_service_proto_enumTypes[0].Descriptor()
}

func (SearchRequest_DynamicFacetSpec_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_search_service_proto_enumTypes[0]
}

func (x SearchRequest_DynamicFacetSpec_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_DynamicFacetSpec_Mode.Descriptor instead.
func (SearchRequest_DynamicFacetSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Enum describing under which condition query expansion should occur.
type SearchRequest_QueryExpansionSpec_Condition int32

const (
	// Unspecified query expansion condition. This defaults to
	// [Condition.DISABLED][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED SearchRequest_QueryExpansionSpec_Condition = 0
	// Disabled query expansion. Only the exact search query is used, even if
	// [SearchResponse.total_size][google.cloud.retail.v2.SearchResponse.total_size]
	// is zero.
	SearchRequest_QueryExpansionSpec_DISABLED SearchRequest_QueryExpansionSpec_Condition = 1
	// Automatic query expansion built by Google Retail Search.
	SearchRequest_QueryExpansionSpec_AUTO SearchRequest_QueryExpansionSpec_Condition = 3
)

// Enum value maps for SearchRequest_QueryExpansionSpec_Condition.
var (
	SearchRequest_QueryExpansionSpec_Condition_name = map[int32]string{
		0: "CONDITION_UNSPECIFIED",
		1: "DISABLED",
		3: "AUTO",
	}
	SearchRequest_QueryExpansionSpec_Condition_value = map[string]int32{
		"CONDITION_UNSPECIFIED": 0,
		"DISABLED":              1,
		"AUTO":                  3,
	}
)

func (x SearchRequest_QueryExpansionSpec_Condition) Enum() *SearchRequest_QueryExpansionSpec_Condition {
	p := new(SearchRequest_QueryExpansionSpec_Condition)
	*p = x
	return p
}

func (x SearchRequest_QueryExpansionSpec_Condition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_QueryExpansionSpec_Condition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2_search_service_proto_enumTypes[1].Descriptor()
}

func (SearchRequest_QueryExpansionSpec_Condition) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2_search_service_proto_enumTypes[1]
}

func (x SearchRequest_QueryExpansionSpec_Condition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec_Condition.Descriptor instead.
func (SearchRequest_QueryExpansionSpec_Condition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Request message for
// [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the search engine placement, such as
	// `projects/*/locations/global/catalogs/default_catalog/placements/default_search`.
	// This field is used to identify the set of models that will be used to make
	// the search.
	//
	// We currently support one placement with the following ID:
	//
	// * `default_search`.
	Placement string `protobuf:"bytes,1,opt,name=placement,proto3" json:"placement,omitempty"`
	// The branch resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/0`.
	//
	// Use "default_branch" as the branch ID or leave this field empty, to search
	// products under the default branch.
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`
	// Raw search query.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Required. A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website.
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	VisitorId string `protobuf:"bytes,4,opt,name=visitor_id,json=visitorId,proto3" json:"visitor_id,omitempty"`
	// User information.
	UserInfo *UserInfo `protobuf:"bytes,5,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
	// unspecified, defaults to a reasonable value. The maximum allowed value is
	// 120. Values above 120 will be coerced to 120.
	//
	// If this field is negative, an INVALID_ARGUMENT is returned.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token
	// [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
	// received from a previous
	// [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
	// match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
	// error is returned.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A 0-indexed integer that specifies the current offset (that is, starting
	// result location, amongst the [Product][google.cloud.retail.v2.Product]s
	// deemed by the API as relevant) in search results. This field is only
	// considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
	// is unset.
	//
	// If this field is negative, an INVALID_ARGUMENT is returned.
	Offset int32 `protobuf:"varint,9,opt,name=offset,proto3" json:"offset,omitempty"`
	// The filter syntax consists of an expression language for constructing a
	// predicate from one or more fields of the products being filtered. Filter
	// expression is case-sensitive.
	//
	// If this field is unrecognizable, an INVALID_ARGUMENT is returned.
	Filter string `protobuf:"bytes,10,opt,name=filter,proto3" json:"filter,omitempty"`
	// The filter applied to every search request when quality improvement such as
	// query expansion is needed. For example, if a query does not have enough
	// results, an expanded query with
	// [SearchRequest.canonical_filter][google.cloud.retail.v2.SearchRequest.canonical_filter]
	// will be returned as a supplement of the original query. This field is
	// strongly recommended to achieve high search quality.
	//
	// See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
	// more details about filter syntax.
	CanonicalFilter string `protobuf:"bytes,28,opt,name=canonical_filter,json=canonicalFilter,proto3" json:"canonical_filter,omitempty"`
	// The order in which products are returned. Products can be ordered by
	// a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
	// unset if ordered by relevance. OrderBy expression is case-sensitive.
	//
	// If this field is unrecognizable, an INVALID_ARGUMENT is returned.
	OrderBy string `protobuf:"bytes,11,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Facet specifications for faceted search. If empty, no facets are returned.
	//
	// A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	FacetSpecs []*SearchRequest_FacetSpec `protobuf:"bytes,12,rep,name=facet_specs,json=facetSpecs,proto3" json:"facet_specs,omitempty"`
	// The specification for dynamically generated facets. Notice that only
	// textual facets can be dynamically generated.
	//
	// This feature requires additional allowlisting. Contact Retail Search
	// support team if you are interested in using dynamic facet feature.
	DynamicFacetSpec *SearchRequest_DynamicFacetSpec `protobuf:"bytes,21,opt,name=dynamic_facet_spec,json=dynamicFacetSpec,proto3" json:"dynamic_facet_spec,omitempty"`
	// Boost specification to boost certain products.
	BoostSpec *SearchRequest_BoostSpec `protobuf:"bytes,13,opt,name=boost_spec,json=boostSpec,proto3" json:"boost_spec,omitempty"`
	// The query expansion specification that specifies the conditions under which
	// query expansion will occur.
	QueryExpansionSpec *SearchRequest_QueryExpansionSpec `protobuf:"bytes,14,opt,name=query_expansion_spec,json=queryExpansionSpec,proto3" json:"query_expansion_spec,omitempty"`
	// The keys to fetch and rollup the matching
	// [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product]s attributes. The attributes from
	// all the matching [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product]s are merged and de-duplicated.
	// Notice that rollup [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product]s attributes will lead to extra
	// query latency. Maximum number of keys is 10.
	//
	// For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
	// fulfillment type and a fulfillment ID must be provided in the format of
	// "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
	// "pickupInStore" is fulfillment type and "store123" is the store ID.
	//
	// Supported keys are:
	//
	// * colorFamilies
	// * price
	// * originalPrice
	// * discount
	// * attributes.key, where key is any key in the
	//   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
	// * pickupInStore.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "pickup-in-store".
	// * shipToStore.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "ship-to-store".
	// * sameDayDelivery.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "same-day-delivery".
	// * nextDayDelivery.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "next-day-delivery".
	// * customFulfillment1.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "custom-type-1".
	// * customFulfillment2.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "custom-type-2".
	// * customFulfillment3.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "custom-type-3".
	// * customFulfillment4.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "custom-type-4".
	// * customFulfillment5.id, where id is any
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
	//   "custom-type-5".
	//
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	VariantRollupKeys []string `protobuf:"bytes,17,rep,name=variant_rollup_keys,json=variantRollupKeys,proto3" json:"variant_rollup_keys,omitempty"`
	// The categories associated with a category page. Required for category
	// navigation queries to achieve good search quality. The format should be
	// the same as
	// [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
	//
	// To represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, please replace it with
	// other character(s).
	//
	// Category pages include special pages such as sales or promotions. For
	// instance, a special sale page may have the category hierarchy:
	// "pageCategories" : ["Sales > 2017 Black Friday Deals"].
	PageCategories []string `protobuf:"bytes,23,rep,name=page_categories,json=pageCategories,proto3" json:"page_categories,omitempty"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchRequest) GetPlacement() string {
	if x != nil {
		return x.Placement
	}
	return ""
}

func (x *SearchRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchRequest) GetVisitorId() string {
	if x != nil {
		return x.VisitorId
	}
	return ""
}

func (x *SearchRequest) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *SearchRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SearchRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SearchRequest) GetCanonicalFilter() string {
	if x != nil {
		return x.CanonicalFilter
	}
	return ""
}

func (x *SearchRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchRequest) GetFacetSpecs() []*SearchRequest_FacetSpec {
	if x != nil {
		return x.FacetSpecs
	}
	return nil
}

func (x *SearchRequest) GetDynamicFacetSpec() *SearchRequest_DynamicFacetSpec {
	if x != nil {
		return x.DynamicFacetSpec
	}
	return nil
}

func (x *SearchRequest) GetBoostSpec() *SearchRequest_BoostSpec {
	if x != nil {
		return x.BoostSpec
	}
	return nil
}

func (x *SearchRequest) GetQueryExpansionSpec() *SearchRequest_QueryExpansionSpec {
	if x != nil {
		return x.QueryExpansionSpec
	}
	return nil
}

func (x *SearchRequest) GetVariantRollupKeys() []string {
	if x != nil {
		return x.VariantRollupKeys
	}
	return nil
}

func (x *SearchRequest) GetPageCategories() []string {
	if x != nil {
		return x.PageCategories
	}
	return nil
}

// Response message for
// [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
type SearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of matched items. The order represents the ranking.
	Results []*SearchResponse_SearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Results of facets requested by user.
	Facets []*SearchResponse_Facet `protobuf:"bytes,2,rep,name=facets,proto3" json:"facets,omitempty"`
	// The estimated total count of matched items irrespective of pagination. The
	// count of [results][google.cloud.retail.v2.SearchResponse.results] returned
	// by pagination may be less than the
	// [total_size][google.cloud.retail.v2.SearchResponse.total_size] that
	// matches.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// If spell correction applies, the corrected query. Otherwise, empty.
	CorrectedQuery string `protobuf:"bytes,4,opt,name=corrected_query,json=correctedQuery,proto3" json:"corrected_query,omitempty"`
	// A unique search token. This should be included in the
	// [UserEvent][google.cloud.retail.v2.UserEvent] logs resulting from this
	// search, which enables accurate attribution of search model performance.
	AttributionToken string `protobuf:"bytes,5,opt,name=attribution_token,json=attributionToken,proto3" json:"attribution_token,omitempty"`
	// A token that can be sent as
	// [SearchRequest.page_token][google.cloud.retail.v2.SearchRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Query expansion information for the returned results.
	QueryExpansionInfo *SearchResponse_QueryExpansionInfo `protobuf:"bytes,7,opt,name=query_expansion_info,json=queryExpansionInfo,proto3" json:"query_expansion_info,omitempty"`
	// The URI of a customer-defined redirect page. If redirect action is
	// triggered, no search will be performed, and only
	// [redirect_uri][google.cloud.retail.v2.SearchResponse.redirect_uri] and
	// [attribution_token][google.cloud.retail.v2.SearchResponse.attribution_token]
	// will be set in the response.
	RedirectUri string `protobuf:"bytes,10,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchResponse) GetResults() []*SearchResponse_SearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchResponse) GetFacets() []*SearchResponse_Facet {
	if x != nil {
		return x.Facets
	}
	return nil
}

func (x *SearchResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchResponse) GetCorrectedQuery() string {
	if x != nil {
		return x.CorrectedQuery
	}
	return ""
}

func (x *SearchResponse) GetAttributionToken() string {
	if x != nil {
		return x.AttributionToken
	}
	return ""
}

func (x *SearchResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchResponse) GetQueryExpansionInfo() *SearchResponse_QueryExpansionInfo {
	if x != nil {
		return x.QueryExpansionInfo
	}
	return nil
}

func (x *SearchResponse) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// A facet specification to perform faceted search.
type SearchRequest_FacetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The facet key specification.
	FacetKey *SearchRequest_FacetSpec_FacetKey `protobuf:"bytes,1,opt,name=facet_key,json=facetKey,proto3" json:"facet_key,omitempty"`
	// Maximum of facet values that should be returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values
	// above 300 will be coerced to 300.
	//
	// If this field is negative, an INVALID_ARGUMENT is returned.
	Limit int32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// List of keys to exclude when faceting.
	//
	// By default,
	// [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
	// is not excluded from the filter unless it is listed in this field.
	//
	// For example, suppose there are 100 products with color facet "Red" and
	// 200 products with color facet "Blue". A query containing the filter
	// "colorFamilies:ANY("Red")" and have "colorFamilies" as
	// [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
	// will by default return the "Red" with count 100.
	//
	// If this field contains "colorFamilies", then the query returns both the
	// "Red" with count 100 and "Blue" with count 200, because the
	// "colorFamilies" key is now excluded from the filter.
	//
	// A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	ExcludedFilterKeys []string `protobuf:"bytes,3,rep,name=excluded_filter_keys,json=excludedFilterKeys,proto3" json:"excluded_filter_keys,omitempty"`
	// Enables dynamic position for this facet. If set to true, the position of
	// this facet among all facets in the response is determined by Google
	// Retail Search. It will be ordered together with dynamic facets if dynamic
	// facets is enabled. If set to false, the position of this facet in the
	// response will be the same as in the request, and it will be ranked before
	// the facets with dynamic position enable and all dynamic facets.
	//
	// For example, you may always want to have rating facet returned in
	// the response, but it's not necessarily to always display the rating facet
	// at the top. In that case, you can set enable_dynamic_position to true so
	// that the position of rating facet in response will be determined by
	// Google Retail Search.
	//
	// Another example, assuming you have the following facets in the request:
	//
	// * "rating", enable_dynamic_position = true
	//
	// * "price", enable_dynamic_position = false
	//
	// * "brands", enable_dynamic_position = false
	//
	// And also you have a dynamic facets enable, which will generate a facet
	// 'gender'. Then the final order of the facets in the response can be
	// ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
	// "rating") depends on how Google Retail Search orders "gender" and
	// "rating" facets. However, notice that "price" and "brands" will always be
	// ranked at 1st and 2nd position since their enable_dynamic_position are
	// false.
	EnableDynamicPosition bool `protobuf:"varint,4,opt,name=enable_dynamic_position,json=enableDynamicPosition,proto3" json:"enable_dynamic_position,omitempty"`
}

func (x *SearchRequest_FacetSpec) Reset() {
	*x = SearchRequest_FacetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_FacetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_FacetSpec) ProtoMessage() {}

func (x *SearchRequest_FacetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_FacetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_FacetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SearchRequest_FacetSpec) GetFacetKey() *SearchRequest_FacetSpec_FacetKey {
	if x != nil {
		return x.FacetKey
	}
	return nil
}

func (x *SearchRequest_FacetSpec) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *SearchRequest_FacetSpec) GetExcludedFilterKeys() []string {
	if x != nil {
		return x.ExcludedFilterKeys
	}
	return nil
}

func (x *SearchRequest_FacetSpec) GetEnableDynamicPosition() bool {
	if x != nil {
		return x.EnableDynamicPosition
	}
	return false
}

// The specifications of dynamically generated facets.
type SearchRequest_DynamicFacetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode of the DynamicFacet feature.
	// Defaults to
	// [Mode.DISABLED][google.cloud.retail.v2.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
	// if it's unset.
	Mode SearchRequest_DynamicFacetSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.retail.v2.SearchRequest_DynamicFacetSpec_Mode" json:"mode,omitempty"`
}

func (x *SearchRequest_DynamicFacetSpec) Reset() {
	*x = SearchRequest_DynamicFacetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_DynamicFacetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_DynamicFacetSpec) ProtoMessage() {}

func (x *SearchRequest_DynamicFacetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_DynamicFacetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_DynamicFacetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SearchRequest_DynamicFacetSpec) GetMode() SearchRequest_DynamicFacetSpec_Mode {
	if x != nil {
		return x.Mode
	}
	return SearchRequest_DynamicFacetSpec_MODE_UNSPECIFIED
}

// Boost specification to boost certain items.
type SearchRequest_BoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Condition boost specifications. If a product matches multiple conditions
	// in the specifictions, boost scores from these specifications are all
	// applied and combined in a non-linear way. Maximum number of
	// specifications is 10.
	ConditionBoostSpecs []*SearchRequest_BoostSpec_ConditionBoostSpec `protobuf:"bytes,1,rep,name=condition_boost_specs,json=conditionBoostSpecs,proto3" json:"condition_boost_specs,omitempty"`
}

func (x *SearchRequest_BoostSpec) Reset() {
	*x = SearchRequest_BoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SearchRequest_BoostSpec) GetConditionBoostSpecs() []*SearchRequest_BoostSpec_ConditionBoostSpec {
	if x != nil {
		return x.ConditionBoostSpecs
	}
	return nil
}

// Specification to determine under which conditions query expansion should
// occur.
type SearchRequest_QueryExpansionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The condition under which query expansion should occur. Default to
	// [Condition.DISABLED][google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	Condition SearchRequest_QueryExpansionSpec_Condition `protobuf:"varint,1,opt,name=condition,proto3,enum=google.cloud.retail.v2.SearchRequest_QueryExpansionSpec_Condition" json:"condition,omitempty"`
	// Whether to pin unexpanded results. If this field is set to true,
	// unexpanded products are always at the top of the search results, followed
	// by the expanded results.
	PinUnexpandedResults bool `protobuf:"varint,2,opt,name=pin_unexpanded_results,json=pinUnexpandedResults,proto3" json:"pin_unexpanded_results,omitempty"`
}

func (x *SearchRequest_QueryExpansionSpec) Reset() {
	*x = SearchRequest_QueryExpansionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_QueryExpansionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_QueryExpansionSpec) ProtoMessage() {}

func (x *SearchRequest_QueryExpansionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_QueryExpansionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 3}
}

func (x *SearchRequest_QueryExpansionSpec) GetCondition() SearchRequest_QueryExpansionSpec_Condition {
	if x != nil {
		return x.Condition
	}
	return SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED
}

func (x *SearchRequest_QueryExpansionSpec) GetPinUnexpandedResults() bool {
	if x != nil {
		return x.PinUnexpandedResults
	}
	return false
}

// Specifies how a facet is computed.
type SearchRequest_FacetSpec_FacetKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Supported textual and numerical facet keys in
	// [Product][google.cloud.retail.v2.Product] object, over which the facet
	// values are computed. Facet key is case-sensitive.
	//
	// Allowed facet keys when
	// [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
	// is not specified:
	//
	// * textual_field =
	//     * "brands"
	//     * "categories"
	//     * "genders"
	//     * "ageGroups"
	//     * "availability"
	//     * "colorFamilies"
	//     * "colors"
	//     * "sizes"
	//     * "materials"
	//     * "patterns"
	//     * "conditions"
	//     * "attributes.key"
	//     * "pickupInStore"
	//     * "shipToStore"
	//     * "sameDayDelivery"
	//     * "nextDayDelivery"
	//     * "customFulfillment1"
	//     * "customFulfillment2"
	//     * "customFulfillment3"
	//     * "customFulfillment4"
	//     * "customFulfillment5"
	//
	// * numerical_field =
	//     * "price"
	//     * "discount"
	//     * "rating"
	//     * "ratingCount"
	//     * "attributes.key"
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Set only if values should be bucketized into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*Interval `protobuf:"bytes,2,rep,name=intervals,proto3" json:"intervals,omitempty"`
	// Only get facet for the given restricted values. For example, when using
	// "pickupInStore" as key and set restricted values to
	// ["store123", "store456"], only facets for "store123" and "store456" are
	// returned. Only supported on textual fields and fulfillments.
	// Maximum is 20.
	//
	// Must be set for the fulfillment facet keys:
	//
	// * pickupInStore
	//
	// * shipToStore
	//
	// * sameDayDelivery
	//
	// * nextDayDelivery
	//
	// * customFulfillment1
	//
	// * customFulfillment2
	//
	// * customFulfillment3
	//
	// * customFulfillment4
	//
	// * customFulfillment5
	RestrictedValues []string `protobuf:"bytes,3,rep,name=restricted_values,json=restrictedValues,proto3" json:"restricted_values,omitempty"`
	// Only get facet values that start with the given string prefix. For
	// example, suppose "categories" has three values "Women > Shoe",
	// "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the
	// "categories" facet will give only "Women > Shoe" and "Women > Dress".
	// Only supported on textual fields. Maximum is 10.
	Prefixes []string `protobuf:"bytes,8,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	// Only get facet values that contains the given strings. For example,
	// suppose "categories" has three values "Women > Shoe",
	// "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
	// "categories" facet will give only "Women > Shoe" and "Men > Shoe".
	// Only supported on textual fields. Maximum is 10.
	Contains []string `protobuf:"bytes,9,rep,name=contains,proto3" json:"contains,omitempty"`
	// The order in which [Facet.values][] are returned.
	//
	// Allowed values are:
	//
	// * "count desc", which means order by [Facet.FacetValue.count][]
	// descending.
	//
	// * "value desc", which means order by [Facet.FacetValue.value][]
	// descending.
	//   Only applies to textual facets.
	//
	// If not set, textual values are sorted in [natural
	// order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
	// intervals are sorted in the order given by
	// [FacetSpec.FacetKey.intervals][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.intervals];
	// [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
	// are sorted in the order given by
	// [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.restricted_values].
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// The query that is used to compute facet for the given facet key.
	// When provided, it will override the default behavior of facet
	// computation. The query syntax is the same as a filter expression. See
	// [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
	// detail syntax and limitations. Notice that there is no limitation on
	// [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
	// when query is specified.
	//
	// In the response, [FacetValue.value][] will be always "1" and
	// [FacetValue.count][] will be the number of results that matches the
	// query.
	//
	// For example, you can set a customized facet for "shipToStore",
	// where
	// [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
	// is "customizedShipToStore", and
	// [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
	// is "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")".
	// Then the facet will count the products that are both in stock and ship
	// to store "123".
	Query string `protobuf:"bytes,5,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *SearchRequest_FacetSpec_FacetKey) Reset() {
	*x = SearchRequest_FacetSpec_FacetKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_FacetSpec_FacetKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_FacetSpec_FacetKey) ProtoMessage() {}

func (x *SearchRequest_FacetSpec_FacetKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_FacetSpec_FacetKey.ProtoReflect.Descriptor instead.
func (*SearchRequest_FacetSpec_FacetKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *SearchRequest_FacetSpec_FacetKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SearchRequest_FacetSpec_FacetKey) GetIntervals() []*Interval {
	if x != nil {
		return x.Intervals
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetRestrictedValues() []string {
	if x != nil {
		return x.RestrictedValues
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetPrefixes() []string {
	if x != nil {
		return x.Prefixes
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetContains() []string {
	if x != nil {
		return x.Contains
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchRequest_FacetSpec_FacetKey) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// Boost applies to products which match a condition.
type SearchRequest_BoostSpec_ConditionBoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
	// detail syntax and limitations.
	//
	// Examples:
	//
	// * To boost products with product ID "product_1" or "product_2", and
	// color
	//   "Red" or "Blue":
	//     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
	//     ANY("Red","Blue"))
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the item a big promotion. However, it does not
	// necessarily mean that the boosted item will be the top result at all
	// times, nor that other items will be excluded. Results could still be
	// shown even when none of them matches the condition. And results that
	// are significantly more relevant to the search query can still trump
	// your heavily favored but irrelevant items.
	//
	// Setting to -1.0 gives the item a big demotion. However, results that
	// are deeply relevant might still be shown. The item will have an
	// upstream battle to get a fairly high ranking, but it is not blocked out
	// completely.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) Reset() {
	*x = SearchRequest_BoostSpec_ConditionBoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec_ConditionBoostSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec_ConditionBoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

// Represents the search results.
type SearchResponse_SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Product.id][google.cloud.retail.v2.Product.id] of the searched
	// [Product][google.cloud.retail.v2.Product].
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The product data snippet in the search response. Only
	// [Product.name][google.cloud.retail.v2.Product.name] is guaranteed to be
	// populated.
	//
	// [Product.variants][google.cloud.retail.v2.Product.variants] contains the
	// product variants that match the search query. If there are multiple
	// product variants matching the query, top 5 most relevant product variants
	// are returned and ordered by relevancy.
	//
	// If relevancy can be deternmined, use
	// [matching_variant_fields][google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields]
	// to look up matched product variants fields. If relevancy cannot be
	// determined, e.g. when searching "shoe" all products in a shoe product can
	// be a match, 5 product variants are returned but order is meaningless.
	Product *Product `protobuf:"bytes,2,opt,name=product,proto3" json:"product,omitempty"`
	// The count of matched
	// [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product]s.
	MatchingVariantCount int32 `protobuf:"varint,3,opt,name=matching_variant_count,json=matchingVariantCount,proto3" json:"matching_variant_count,omitempty"`
	// If a [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product] matches the search query, this
	// map indicates which [Product][google.cloud.retail.v2.Product] fields are
	// matched. The key is the
	// [Product.name][google.cloud.retail.v2.Product.name], the value is a field
	// mask of the matched [Product][google.cloud.retail.v2.Product] fields. If
	// matched attributes cannot be determined, this map will be empty.
	//
	// For example, a key "sku1" with field mask
	// "products.color_info" indicates there is a match between
	// "sku1" [ColorInfo][google.cloud.retail.v2.ColorInfo] and the query.
	MatchingVariantFields map[string]*fieldmaskpb.FieldMask `protobuf:"bytes,4,rep,name=matching_variant_fields,json=matchingVariantFields,proto3" json:"matching_variant_fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The rollup matching
	// [variant][google.cloud.retail.v2.Product.Type.VARIANT]
	// [Product][google.cloud.retail.v2.Product] attributes. The key is one of
	// the
	// [SearchRequest.variant_rollup_keys][google.cloud.retail.v2.SearchRequest.variant_rollup_keys].
	// The values are the merged and de-duplicated
	// [Product][google.cloud.retail.v2.Product] attributes. Notice that the
	// rollup values are respect filter. For example, when filtering by
	// "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red" is
	// returned.
	//
	// For textual and numerical attributes, the rollup values is a list of
	// string or double values with type
	// [google.protobuf.ListValue][google.protobuf.ListValue]. For example, if
	// there are two variants with colors "red" and "blue", the rollup values
	// are
	//
	//     { key: "colorFamilies"
	//       value {
	//         list_value {
	//           values { string_value: "red" }
	//           values { string_value: "blue" }
	//          }
	//       }
	//     }
	//
	// For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], the rollup
	// values is a double value with type
	// [google.protobuf.Value][google.protobuf.Value]. For example,
	// `{key: "pickupInStore.store1" value { number_value: 10 }}` means a there
	// are 10 variants in this product are available in the store "store1".
	VariantRollupValues map[string]*structpb.Value `protobuf:"bytes,5,rep,name=variant_rollup_values,json=variantRollupValues,proto3" json:"variant_rollup_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SearchResponse_SearchResult) Reset() {
	*x = SearchResponse_SearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_SearchResult) ProtoMessage() {}

func (x *SearchResponse_SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResponse_SearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *SearchResponse_SearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SearchResponse_SearchResult) GetProduct() *Product {
	if x != nil {
		return x.Product
	}
	return nil
}

func (x *SearchResponse_SearchResult) GetMatchingVariantCount() int32 {
	if x != nil {
		return x.MatchingVariantCount
	}
	return 0
}

func (x *SearchResponse_SearchResult) GetMatchingVariantFields() map[string]*fieldmaskpb.FieldMask {
	if x != nil {
		return x.MatchingVariantFields
	}
	return nil
}

func (x *SearchResponse_SearchResult) GetVariantRollupValues() map[string]*structpb.Value {
	if x != nil {
		return x.VariantRollupValues
	}
	return nil
}

// A facet result.
type SearchResponse_Facet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key for this facet. E.g., "colorFamilies" or "price" or
	// "attributes.attr1".
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The facet values for this field.
	Values []*SearchResponse_Facet_FacetValue `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Whether the facet is dynamically generated.
	DynamicFacet bool `protobuf:"varint,3,opt,name=dynamic_facet,json=dynamicFacet,proto3" json:"dynamic_facet,omitempty"`
}

func (x *SearchResponse_Facet) Reset() {
	*x = SearchResponse_Facet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Facet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Facet) ProtoMessage() {}

func (x *SearchResponse_Facet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Facet.ProtoReflect.Descriptor instead.
func (*SearchResponse_Facet) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *SearchResponse_Facet) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SearchResponse_Facet) GetValues() []*SearchResponse_Facet_FacetValue {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *SearchResponse_Facet) GetDynamicFacet() bool {
	if x != nil {
		return x.DynamicFacet
	}
	return false
}

// Information describing query expansion including whether expansion has
// occurred.
type SearchResponse_QueryExpansionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bool describing whether query expansion has occurred.
	ExpandedQuery bool `protobuf:"varint,1,opt,name=expanded_query,json=expandedQuery,proto3" json:"expanded_query,omitempty"`
	// Number of pinned results. This field will only be set when expansion
	// happens and [SearchRequest.query_expansion_spec.pin_unexpanded_results][]
	// is set to true.
	PinnedResultCount int64 `protobuf:"varint,2,opt,name=pinned_result_count,json=pinnedResultCount,proto3" json:"pinned_result_count,omitempty"`
}

func (x *SearchResponse_QueryExpansionInfo) Reset() {
	*x = SearchResponse_QueryExpansionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_QueryExpansionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_QueryExpansionInfo) ProtoMessage() {}

func (x *SearchResponse_QueryExpansionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_QueryExpansionInfo.ProtoReflect.Descriptor instead.
func (*SearchResponse_QueryExpansionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{1, 2}
}

func (x *SearchResponse_QueryExpansionInfo) GetExpandedQuery() bool {
	if x != nil {
		return x.ExpandedQuery
	}
	return false
}

func (x *SearchResponse_QueryExpansionInfo) GetPinnedResultCount() int64 {
	if x != nil {
		return x.PinnedResultCount
	}
	return 0
}

// A facet value which contains value names and their count.
type SearchResponse_Facet_FacetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A facet value which contains values.
	//
	// Types that are assignable to FacetValue:
	//	*SearchResponse_Facet_FacetValue_Value
	//	*SearchResponse_Facet_FacetValue_Interval
	FacetValue isSearchResponse_Facet_FacetValue_FacetValue `protobuf_oneof:"facet_value"`
	// Number of items that have this facet value.
	Count int64 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SearchResponse_Facet_FacetValue) Reset() {
	*x = SearchResponse_Facet_FacetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Facet_FacetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Facet_FacetValue) ProtoMessage() {}

func (x *SearchResponse_Facet_FacetValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2_search_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Facet_FacetValue.ProtoReflect.Descriptor instead.
func (*SearchResponse_Facet_FacetValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2_search_service_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (m *SearchResponse_Facet_FacetValue) GetFacetValue() isSearchResponse_Facet_FacetValue_FacetValue {
	if m != nil {
		return m.FacetValue
	}
	return nil
}

func (x *SearchResponse_Facet_FacetValue) GetValue() string {
	if x, ok := x.GetFacetValue().(*SearchResponse_Facet_FacetValue_Value); ok {
		return x.Value
	}
	return ""
}

func (x *SearchResponse_Facet_FacetValue) GetInterval() *Interval {
	if x, ok := x.GetFacetValue().(*SearchResponse_Facet_FacetValue_Interval); ok {
		return x.Interval
	}
	return nil
}

func (x *SearchResponse_Facet_FacetValue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

type isSearchResponse_Facet_FacetValue_FacetValue interface {
	isSearchResponse_Facet_FacetValue_FacetValue()
}

type SearchResponse_Facet_FacetValue_Value struct {
	// Text value of a facet, such as "Black" for facet "colorFamilies".
	Value string `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type SearchResponse_Facet_FacetValue_Interval struct {
	// Interval value for a facet, such as [10, 20) for facet "price".
	Interval *Interval `protobuf:"bytes,2,opt,name=interval,proto3,oneof"`
}

func (*SearchResponse_Facet_FacetValue_Value) isSearchResponse_Facet_FacetValue_FacetValue() {}

func (*SearchResponse_Facet_FacetValue_Interval) isSearchResponse_Facet_FacetValue_FacetValue() {}

var File_google_cloud_retail_v2_search_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2_search_service_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa7, 0x0f, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x41, 0x1e, 0x0a, 0x1c,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x62, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x3d,
	0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x1c, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x50, 0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x66, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x73, 0x12, 0x64, 0x0a, 0x12, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x66, 0x61, 0x63,
	0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x10, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4e, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x73, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6a, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x12, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x13, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x72,
	0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x11, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61,
	0x67, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xe1, 0x03, 0x0a,
	0x09, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5a, 0x0a, 0x09, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46,
	0x61, 0x63, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x30, 0x0a, 0x14,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x36,
	0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xf7, 0x01, 0x0a, 0x08, 0x46, 0x61, 0x63, 0x65, 0x74,
	0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x09, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52,
	0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12,
	0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x1a, 0x9c, 0x01, 0x0a, 0x10, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4f, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x37, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x1a,
	0xcd, 0x01, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x76, 0x0a,
	0x15, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0x48, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x1a,
	0xec, 0x01, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x69, 0x6e, 0x5f,
	0x75, 0x6e, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x70, 0x69, 0x6e, 0x55, 0x6e, 0x65,
	0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x3e,
	0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x43,
	0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x03, 0x22, 0xc1,
	0x0b, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4d, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x44, 0x0a, 0x06, 0x66, 0x61, 0x63, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x06,
	0x66, 0x61, 0x63, 0x65, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2b,
	0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x6b, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x55, 0x72, 0x69, 0x1a, 0xe1, 0x04, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x39, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12,
	0x34, 0x0a, 0x16, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x14, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x86, 0x01, 0x0a, 0x17, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x15, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x80,
	0x01, 0x0a, 0x15, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x75,
	0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75,
	0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x13, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x1a, 0x64, 0x0a, 0x1a, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5e, 0x0a, 0x18, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x75, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x9b, 0x02, 0x0a, 0x05, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f,
	0x66, 0x61, 0x63, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63, 0x65, 0x74, 0x1a, 0x89, 0x01, 0x0a, 0x0a, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x3e, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x6b, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x65,
	0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x11, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x32, 0x86, 0x02, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xa9, 0x01, 0x0a, 0x06, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x45, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a,
	0x1a, 0x49, 0xca, 0x41, 0x15, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xc7, 0x01, 0x0a, 0x1a,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x42, 0x12, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0xa2, 0x02,
	0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56, 0x32,
	0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2_search_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2_search_service_proto_rawDescData = file_google_cloud_retail_v2_search_service_proto_rawDesc
)

func file_google_cloud_retail_v2_search_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2_search_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2_search_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2_search_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2_search_service_proto_rawDescData
}

var file_google_cloud_retail_v2_search_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_retail_v2_search_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_retail_v2_search_service_proto_goTypes = []interface{}{
	(SearchRequest_DynamicFacetSpec_Mode)(0),           // 0: google.cloud.retail.v2.SearchRequest.DynamicFacetSpec.Mode
	(SearchRequest_QueryExpansionSpec_Condition)(0),    // 1: google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.Condition
	(*SearchRequest)(nil),                              // 2: google.cloud.retail.v2.SearchRequest
	(*SearchResponse)(nil),                             // 3: google.cloud.retail.v2.SearchResponse
	(*SearchRequest_FacetSpec)(nil),                    // 4: google.cloud.retail.v2.SearchRequest.FacetSpec
	(*SearchRequest_DynamicFacetSpec)(nil),             // 5: google.cloud.retail.v2.SearchRequest.DynamicFacetSpec
	(*SearchRequest_BoostSpec)(nil),                    // 6: google.cloud.retail.v2.SearchRequest.BoostSpec
	(*SearchRequest_QueryExpansionSpec)(nil),           // 7: google.cloud.retail.v2.SearchRequest.QueryExpansionSpec
	(*SearchRequest_FacetSpec_FacetKey)(nil),           // 8: google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey
	(*SearchRequest_BoostSpec_ConditionBoostSpec)(nil), // 9: google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
	(*SearchResponse_SearchResult)(nil),                // 10: google.cloud.retail.v2.SearchResponse.SearchResult
	(*SearchResponse_Facet)(nil),                       // 11: google.cloud.retail.v2.SearchResponse.Facet
	(*SearchResponse_QueryExpansionInfo)(nil),          // 12: google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
	nil,                                     // 13: google.cloud.retail.v2.SearchResponse.SearchResult.MatchingVariantFieldsEntry
	nil,                                     // 14: google.cloud.retail.v2.SearchResponse.SearchResult.VariantRollupValuesEntry
	(*SearchResponse_Facet_FacetValue)(nil), // 15: google.cloud.retail.v2.SearchResponse.Facet.FacetValue
	(*UserInfo)(nil),                        // 16: google.cloud.retail.v2.UserInfo
	(*Interval)(nil),                        // 17: google.cloud.retail.v2.Interval
	(*Product)(nil),                         // 18: google.cloud.retail.v2.Product
	(*fieldmaskpb.FieldMask)(nil),           // 19: google.protobuf.FieldMask
	(*structpb.Value)(nil),                  // 20: google.protobuf.Value
}
var file_google_cloud_retail_v2_search_service_proto_depIdxs = []int32{
	16, // 0: google.cloud.retail.v2.SearchRequest.user_info:type_name -> google.cloud.retail.v2.UserInfo
	4,  // 1: google.cloud.retail.v2.SearchRequest.facet_specs:type_name -> google.cloud.retail.v2.SearchRequest.FacetSpec
	5,  // 2: google.cloud.retail.v2.SearchRequest.dynamic_facet_spec:type_name -> google.cloud.retail.v2.SearchRequest.DynamicFacetSpec
	6,  // 3: google.cloud.retail.v2.SearchRequest.boost_spec:type_name -> google.cloud.retail.v2.SearchRequest.BoostSpec
	7,  // 4: google.cloud.retail.v2.SearchRequest.query_expansion_spec:type_name -> google.cloud.retail.v2.SearchRequest.QueryExpansionSpec
	10, // 5: google.cloud.retail.v2.SearchResponse.results:type_name -> google.cloud.retail.v2.SearchResponse.SearchResult
	11, // 6: google.cloud.retail.v2.SearchResponse.facets:type_name -> google.cloud.retail.v2.SearchResponse.Facet
	12, // 7: google.cloud.retail.v2.SearchResponse.query_expansion_info:type_name -> google.cloud.retail.v2.SearchResponse.QueryExpansionInfo
	8,  // 8: google.cloud.retail.v2.SearchRequest.FacetSpec.facet_key:type_name -> google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey
	0,  // 9: google.cloud.retail.v2.SearchRequest.DynamicFacetSpec.mode:type_name -> google.cloud.retail.v2.SearchRequest.DynamicFacetSpec.Mode
	9,  // 10: google.cloud.retail.v2.SearchRequest.BoostSpec.condition_boost_specs:type_name -> google.cloud.retail.v2.SearchRequest.BoostSpec.ConditionBoostSpec
	1,  // 11: google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.condition:type_name -> google.cloud.retail.v2.SearchRequest.QueryExpansionSpec.Condition
	17, // 12: google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.intervals:type_name -> google.cloud.retail.v2.Interval
	18, // 13: google.cloud.retail.v2.SearchResponse.SearchResult.product:type_name -> google.cloud.retail.v2.Product
	13, // 14: google.cloud.retail.v2.SearchResponse.SearchResult.matching_variant_fields:type_name -> google.cloud.retail.v2.SearchResponse.SearchResult.MatchingVariantFieldsEntry
	14, // 15: google.cloud.retail.v2.SearchResponse.SearchResult.variant_rollup_values:type_name -> google.cloud.retail.v2.SearchResponse.SearchResult.VariantRollupValuesEntry
	15, // 16: google.cloud.retail.v2.SearchResponse.Facet.values:type_name -> google.cloud.retail.v2.SearchResponse.Facet.FacetValue
	19, // 17: google.cloud.retail.v2.SearchResponse.SearchResult.MatchingVariantFieldsEntry.value:type_name -> google.protobuf.FieldMask
	20, // 18: google.cloud.retail.v2.SearchResponse.SearchResult.VariantRollupValuesEntry.value:type_name -> google.protobuf.Value
	17, // 19: google.cloud.retail.v2.SearchResponse.Facet.FacetValue.interval:type_name -> google.cloud.retail.v2.Interval
	2,  // 20: google.cloud.retail.v2.SearchService.Search:input_type -> google.cloud.retail.v2.SearchRequest
	3,  // 21: google.cloud.retail.v2.SearchService.Search:output_type -> google.cloud.retail.v2.SearchResponse
	21, // [21:22] is the sub-list for method output_type
	20, // [20:21] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2_search_service_proto_init() }
func file_google_cloud_retail_v2_search_service_proto_init() {
	if File_google_cloud_retail_v2_search_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2_common_proto_init()
	file_google_cloud_retail_v2_product_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2_search_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_FacetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_DynamicFacetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_QueryExpansionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_FacetSpec_FacetKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec_ConditionBoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_SearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Facet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_QueryExpansionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2_search_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Facet_FacetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_retail_v2_search_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*SearchResponse_Facet_FacetValue_Value)(nil),
		(*SearchResponse_Facet_FacetValue_Interval)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2_search_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2_search_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2_search_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2_search_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2_search_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2_search_service_proto = out.File
	file_google_cloud_retail_v2_search_service_proto_rawDesc = nil
	file_google_cloud_retail_v2_search_service_proto_goTypes = nil
	file_google_cloud_retail_v2_search_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SearchServiceClient is the client API for SearchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SearchServiceClient interface {
	// Performs a search.
	//
	// This feature is only available for users who have Retail Search enabled.
	// Please submit a form [here](https://cloud.google.com/contact) to contact
	// cloud sales if you are interested in using Retail Search.
	Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error)
}

type searchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchServiceClient(cc grpc.ClientConnInterface) SearchServiceClient {
	return &searchServiceClient{cc}
}

func (c *searchServiceClient) Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error) {
	out := new(SearchResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.retail.v2.SearchService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchServiceServer is the server API for SearchService service.
type SearchServiceServer interface {
	// Performs a search.
	//
	// This feature is only available for users who have Retail Search enabled.
	// Please submit a form [here](https://cloud.google.com/contact) to contact
	// cloud sales if you are interested in using Retail Search.
	Search(context.Context, *SearchRequest) (*SearchResponse, error)
}

// UnimplementedSearchServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSearchServiceServer struct {
}

func (*UnimplementedSearchServiceServer) Search(context.Context, *SearchRequest) (*SearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Search not implemented")
}

func RegisterSearchServiceServer(s *grpc.Server, srv SearchServiceServer) {
	s.RegisterService(&_SearchService_serviceDesc, srv)
}

func _SearchService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.retail.v2.SearchService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Search(ctx, req.(*SearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SearchService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2.SearchService",
	HandlerType: (*SearchServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _SearchService_Search_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2/search_service.proto",
}
