package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachVbrToVpconn invokes the vpc.AttachVbrToVpconn API synchronously
func (client *Client) AttachVbrToVpconn(request *AttachVbrToVpconnRequest) (response *AttachVbrToVpconnResponse, err error) {
	response = CreateAttachVbrToVpconnResponse()
	err = client.DoAction(request, response)
	return
}

// AttachVbrToVpconnWithChan invokes the vpc.AttachVbrToVpconn API asynchronously
func (client *Client) AttachVbrToVpconnWithChan(request *AttachVbrToVpconnRequest) (<-chan *AttachVbrToVpconnResponse, <-chan error) {
	responseChan := make(chan *AttachVbrToVpconnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachVbrToVpconn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachVbrToVpconnWithCallback invokes the vpc.AttachVbrToVpconn API asynchronously
func (client *Client) AttachVbrToVpconnWithCallback(request *AttachVbrToVpconnRequest, callback func(response *AttachVbrToVpconnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachVbrToVpconnResponse
		var err error
		defer close(result)
		response, err = client.AttachVbrToVpconn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachVbrToVpconnRequest is the request struct for api AttachVbrToVpconn
type AttachVbrToVpconnRequest struct {
	*requests.RpcRequest
	DryRun   requests.Boolean `position:"Query" name:"DryRun"`
	VpconnId string           `position:"Query" name:"VpconnId"`
	VbrId    string           `position:"Query" name:"VbrId"`
	Token    string           `position:"Query" name:"Token"`
}

// AttachVbrToVpconnResponse is the response struct for api AttachVbrToVpconn
type AttachVbrToVpconnResponse struct {
	*responses.BaseResponse
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	VirtualPhysicalConnection string `json:"VirtualPhysicalConnection" xml:"VirtualPhysicalConnection"`
}

// CreateAttachVbrToVpconnRequest creates a request to invoke AttachVbrToVpconn API
func CreateAttachVbrToVpconnRequest() (request *AttachVbrToVpconnRequest) {
	request = &AttachVbrToVpconnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AttachVbrToVpconn", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachVbrToVpconnResponse creates a response to parse from AttachVbrToVpconn response
func CreateAttachVbrToVpconnResponse() (response *AttachVbrToVpconnResponse) {
	response = &AttachVbrToVpconnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
