package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDynamicImage invokes the vod.ListDynamicImage API synchronously
func (client *Client) ListDynamicImage(request *ListDynamicImageRequest) (response *ListDynamicImageResponse, err error) {
	response = CreateListDynamicImageResponse()
	err = client.DoAction(request, response)
	return
}

// ListDynamicImageWithChan invokes the vod.ListDynamicImage API asynchronously
func (client *Client) ListDynamicImageWithChan(request *ListDynamicImageRequest) (<-chan *ListDynamicImageResponse, <-chan error) {
	responseChan := make(chan *ListDynamicImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDynamicImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDynamicImageWithCallback invokes the vod.ListDynamicImage API asynchronously
func (client *Client) ListDynamicImageWithCallback(request *ListDynamicImageRequest, callback func(response *ListDynamicImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDynamicImageResponse
		var err error
		defer close(result)
		response, err = client.ListDynamicImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDynamicImageRequest is the request struct for api ListDynamicImage
type ListDynamicImageRequest struct {
	*requests.RpcRequest
	VideoId string `position:"Query" name:"VideoId"`
}

// ListDynamicImageResponse is the response struct for api ListDynamicImage
type ListDynamicImageResponse struct {
	*responses.BaseResponse
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	DynamicImageList []DynamicImage `json:"DynamicImageList" xml:"DynamicImageList"`
}

// CreateListDynamicImageRequest creates a request to invoke ListDynamicImage API
func CreateListDynamicImageRequest() (request *ListDynamicImageRequest) {
	request = &ListDynamicImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListDynamicImage", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDynamicImageResponse creates a response to parse from ListDynamicImage response
func CreateListDynamicImageResponse() (response *ListDynamicImageResponse) {
	response = &ListDynamicImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
