package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ServingPlanMigrate invokes the unimkt.ServingPlanMigrate API synchronously
func (client *Client) ServingPlanMigrate(request *ServingPlanMigrateRequest) (response *ServingPlanMigrateResponse, err error) {
	response = CreateServingPlanMigrateResponse()
	err = client.DoAction(request, response)
	return
}

// ServingPlanMigrateWithChan invokes the unimkt.ServingPlanMigrate API asynchronously
func (client *Client) ServingPlanMigrateWithChan(request *ServingPlanMigrateRequest) (<-chan *ServingPlanMigrateResponse, <-chan error) {
	responseChan := make(chan *ServingPlanMigrateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ServingPlanMigrate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ServingPlanMigrateWithCallback invokes the unimkt.ServingPlanMigrate API asynchronously
func (client *Client) ServingPlanMigrateWithCallback(request *ServingPlanMigrateRequest, callback func(response *ServingPlanMigrateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ServingPlanMigrateResponse
		var err error
		defer close(result)
		response, err = client.ServingPlanMigrate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ServingPlanMigrateRequest is the request struct for api ServingPlanMigrate
type ServingPlanMigrateRequest struct {
	*requests.RpcRequest
	QuotaPerDay   string `position:"Body" name:"QuotaPerDay"`
	BrandUserId   string `position:"Body" name:"BrandUserId"`
	EndTime       string `position:"Body" name:"EndTime"`
	BrandUserNick string `position:"Body" name:"BrandUserNick"`
	StartTime     string `position:"Body" name:"StartTime"`
	ProxyUserId   string `position:"Body" name:"ProxyUserId"`
	BizType       string `position:"Body" name:"BizType"`
	Quota         string `position:"Body" name:"Quota"`
	Name          string `position:"Body" name:"Name"`
	ProxyUserNick string `position:"Body" name:"ProxyUserNick"`
	PayType       string `position:"Body" name:"PayType"`
	TaskId        string `position:"Body" name:"TaskId"`
	Status        string `position:"Body" name:"Status"`
}

// ServingPlanMigrateResponse is the response struct for api ServingPlanMigrate
type ServingPlanMigrateResponse struct {
	*responses.BaseResponse
	Status    int    `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateServingPlanMigrateRequest creates a request to invoke ServingPlanMigrate API
func CreateServingPlanMigrateRequest() (request *ServingPlanMigrateRequest) {
	request = &ServingPlanMigrateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-07", "ServingPlanMigrate", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateServingPlanMigrateResponse creates a response to parse from ServingPlanMigrate response
func CreateServingPlanMigrateResponse() (response *ServingPlanMigrateResponse) {
	response = &ServingPlanMigrateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
