package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveCpmTrade invokes the unimkt.SaveCpmTrade API synchronously
func (client *Client) SaveCpmTrade(request *SaveCpmTradeRequest) (response *SaveCpmTradeResponse, err error) {
	response = CreateSaveCpmTradeResponse()
	err = client.DoAction(request, response)
	return
}

// SaveCpmTradeWithChan invokes the unimkt.SaveCpmTrade API asynchronously
func (client *Client) SaveCpmTradeWithChan(request *SaveCpmTradeRequest) (<-chan *SaveCpmTradeResponse, <-chan error) {
	responseChan := make(chan *SaveCpmTradeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveCpmTrade(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveCpmTradeWithCallback invokes the unimkt.SaveCpmTrade API asynchronously
func (client *Client) SaveCpmTradeWithCallback(request *SaveCpmTradeRequest, callback func(response *SaveCpmTradeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveCpmTradeResponse
		var err error
		defer close(result)
		response, err = client.SaveCpmTrade(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveCpmTradeRequest is the request struct for api SaveCpmTrade
type SaveCpmTradeRequest struct {
	*requests.RpcRequest
	TaskType       string           `position:"Query" name:"TaskType"`
	RealCostAmount string           `position:"Query" name:"RealCostAmount"`
	Sex            string           `position:"Query" name:"Sex"`
	CostDetail     string           `position:"Query" name:"CostDetail"`
	TaskTag        string           `position:"Query" name:"TaskTag"`
	BizType        string           `position:"Query" name:"BizType"`
	DeviceCode     string           `position:"Query" name:"DeviceCode"`
	V              string           `position:"Query" name:"V"`
	ApplyPrice     string           `position:"Query" name:"ApplyPrice"`
	ChargeType     string           `position:"Query" name:"ChargeType"`
	HoldId         string           `position:"Query" name:"HoldId"`
	ExtendString   string           `position:"Query" name:"ExtendString"`
	ChannelId      string           `position:"Query" name:"ChannelId"`
	Age            requests.Integer `position:"Query" name:"Age"`
	TaskId         string           `position:"Query" name:"TaskId"`
	AdvertType     string           `position:"Query" name:"AdvertType"`
	OuterCode      string           `position:"Query" name:"OuterCode"`
	TradeTime      requests.Integer `position:"Query" name:"TradeTime"`
}

// SaveCpmTradeResponse is the response struct for api SaveCpmTrade
type SaveCpmTradeResponse struct {
	*responses.BaseResponse
	Status    bool   `json:"Status" xml:"Status"`
	Msg       string `json:"Msg" xml:"Msg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSaveCpmTradeRequest creates a request to invoke SaveCpmTrade API
func CreateSaveCpmTradeRequest() (request *SaveCpmTradeRequest) {
	request = &SaveCpmTradeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "SaveCpmTrade", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveCpmTradeResponse creates a response to parse from SaveCpmTrade response
func CreateSaveCpmTradeResponse() (response *SaveCpmTradeResponse) {
	response = &SaveCpmTradeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
