package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUisNode invokes the uis.DeleteUisNode API synchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnode.html
func (client *Client) DeleteUisNode(request *DeleteUisNodeRequest) (response *DeleteUisNodeResponse, err error) {
	response = CreateDeleteUisNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUisNodeWithChan invokes the uis.DeleteUisNode API asynchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUisNodeWithChan(request *DeleteUisNodeRequest) (<-chan *DeleteUisNodeResponse, <-chan error) {
	responseChan := make(chan *DeleteUisNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUisNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUisNodeWithCallback invokes the uis.DeleteUisNode API asynchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUisNodeWithCallback(request *DeleteUisNodeRequest, callback func(response *DeleteUisNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUisNodeResponse
		var err error
		defer close(result)
		response, err = client.DeleteUisNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUisNodeRequest is the request struct for api DeleteUisNode
type DeleteUisNodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UisId                string           `position:"Query" name:"UisId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteUisNodeResponse is the response struct for api DeleteUisNode
type DeleteUisNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUisNodeRequest creates a request to invoke DeleteUisNode API
func CreateDeleteUisNodeRequest() (request *DeleteUisNodeRequest) {
	request = &DeleteUisNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DeleteUisNode", "uis", "openAPI")
	return
}

// CreateDeleteUisNodeResponse creates a response to parse from DeleteUisNode response
func CreateDeleteUisNodeResponse() (response *DeleteUisNodeResponse) {
	response = &DeleteUisNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
