package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUisNetworkInterface invokes the uis.DeleteUisNetworkInterface API synchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnetworkinterface.html
func (client *Client) DeleteUisNetworkInterface(request *DeleteUisNetworkInterfaceRequest) (response *DeleteUisNetworkInterfaceResponse, err error) {
	response = CreateDeleteUisNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUisNetworkInterfaceWithChan invokes the uis.DeleteUisNetworkInterface API asynchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnetworkinterface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUisNetworkInterfaceWithChan(request *DeleteUisNetworkInterfaceRequest) (<-chan *DeleteUisNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *DeleteUisNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUisNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUisNetworkInterfaceWithCallback invokes the uis.DeleteUisNetworkInterface API asynchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnetworkinterface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUisNetworkInterfaceWithCallback(request *DeleteUisNetworkInterfaceRequest, callback func(response *DeleteUisNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUisNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.DeleteUisNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUisNetworkInterfaceRequest is the request struct for api DeleteUisNetworkInterface
type DeleteUisNetworkInterfaceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UisEniId             string           `position:"Query" name:"UisEniId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteUisNetworkInterfaceResponse is the response struct for api DeleteUisNetworkInterface
type DeleteUisNetworkInterfaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUisNetworkInterfaceRequest creates a request to invoke DeleteUisNetworkInterface API
func CreateDeleteUisNetworkInterfaceRequest() (request *DeleteUisNetworkInterfaceRequest) {
	request = &DeleteUisNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DeleteUisNetworkInterface", "uis", "openAPI")
	return
}

// CreateDeleteUisNetworkInterfaceResponse creates a response to parse from DeleteUisNetworkInterface response
func CreateDeleteUisNetworkInterfaceResponse() (response *DeleteUisNetworkInterfaceResponse) {
	response = &DeleteUisNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
