package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDeviceAutoUpgradePolicy invokes the smartag.DescribeDeviceAutoUpgradePolicy API synchronously
func (client *Client) DescribeDeviceAutoUpgradePolicy(request *DescribeDeviceAutoUpgradePolicyRequest) (response *DescribeDeviceAutoUpgradePolicyResponse, err error) {
	response = CreateDescribeDeviceAutoUpgradePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDeviceAutoUpgradePolicyWithChan invokes the smartag.DescribeDeviceAutoUpgradePolicy API asynchronously
func (client *Client) DescribeDeviceAutoUpgradePolicyWithChan(request *DescribeDeviceAutoUpgradePolicyRequest) (<-chan *DescribeDeviceAutoUpgradePolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeDeviceAutoUpgradePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDeviceAutoUpgradePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDeviceAutoUpgradePolicyWithCallback invokes the smartag.DescribeDeviceAutoUpgradePolicy API asynchronously
func (client *Client) DescribeDeviceAutoUpgradePolicyWithCallback(request *DescribeDeviceAutoUpgradePolicyRequest, callback func(response *DescribeDeviceAutoUpgradePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDeviceAutoUpgradePolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDeviceAutoUpgradePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDeviceAutoUpgradePolicyRequest is the request struct for api DescribeDeviceAutoUpgradePolicy
type DescribeDeviceAutoUpgradePolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VersionType          string           `position:"Query" name:"VersionType"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeDeviceAutoUpgradePolicyResponse is the response struct for api DescribeDeviceAutoUpgradePolicy
type DescribeDeviceAutoUpgradePolicyResponse struct {
	*responses.BaseResponse
	UpgradeType    string `json:"UpgradeType" xml:"UpgradeType"`
	TimeZone       string `json:"TimeZone" xml:"TimeZone"`
	SerialNumber   string `json:"SerialNumber" xml:"SerialNumber"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Jitter         string `json:"Jitter" xml:"Jitter"`
	Duration       string `json:"Duration" xml:"Duration"`
	CronExpression string `json:"CronExpression" xml:"CronExpression"`
	SmartAGId      string `json:"SmartAGId" xml:"SmartAGId"`
}

// CreateDescribeDeviceAutoUpgradePolicyRequest creates a request to invoke DescribeDeviceAutoUpgradePolicy API
func CreateDescribeDeviceAutoUpgradePolicyRequest() (request *DescribeDeviceAutoUpgradePolicyRequest) {
	request = &DescribeDeviceAutoUpgradePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeDeviceAutoUpgradePolicy", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDeviceAutoUpgradePolicyResponse creates a response to parse from DescribeDeviceAutoUpgradePolicy response
func CreateDescribeDeviceAutoUpgradePolicyResponse() (response *DescribeDeviceAutoUpgradePolicyResponse) {
	response = &DescribeDeviceAutoUpgradePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
