package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDefaultLevel invokes the sddp.ModifyDefaultLevel API synchronously
func (client *Client) ModifyDefaultLevel(request *ModifyDefaultLevelRequest) (response *ModifyDefaultLevelResponse, err error) {
	response = CreateModifyDefaultLevelResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDefaultLevelWithChan invokes the sddp.ModifyDefaultLevel API asynchronously
func (client *Client) ModifyDefaultLevelWithChan(request *ModifyDefaultLevelRequest) (<-chan *ModifyDefaultLevelResponse, <-chan error) {
	responseChan := make(chan *ModifyDefaultLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDefaultLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDefaultLevelWithCallback invokes the sddp.ModifyDefaultLevel API asynchronously
func (client *Client) ModifyDefaultLevelWithCallback(request *ModifyDefaultLevelRequest, callback func(response *ModifyDefaultLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDefaultLevelResponse
		var err error
		defer close(result)
		response, err = client.ModifyDefaultLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDefaultLevelRequest is the request struct for api ModifyDefaultLevel
type ModifyDefaultLevelRequest struct {
	*requests.RpcRequest
	FeatureType  requests.Integer `position:"Query" name:"FeatureType"`
	DefaultId    requests.Integer `position:"Query" name:"DefaultId"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	Lang         string           `position:"Query" name:"Lang"`
	SensitiveIds string           `position:"Query" name:"SensitiveIds"`
}

// ModifyDefaultLevelResponse is the response struct for api ModifyDefaultLevel
type ModifyDefaultLevelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDefaultLevelRequest creates a request to invoke ModifyDefaultLevel API
func CreateModifyDefaultLevelRequest() (request *ModifyDefaultLevelRequest) {
	request = &ModifyDefaultLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "ModifyDefaultLevel", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDefaultLevelResponse creates a response to parse from ModifyDefaultLevel response
func CreateModifyDefaultLevelResponse() (response *ModifyDefaultLevelResponse) {
	response = &ModifyDefaultLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
