package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRiskLevels invokes the sddp.DescribeRiskLevels API synchronously
func (client *Client) DescribeRiskLevels(request *DescribeRiskLevelsRequest) (response *DescribeRiskLevelsResponse, err error) {
	response = CreateDescribeRiskLevelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRiskLevelsWithChan invokes the sddp.DescribeRiskLevels API asynchronously
func (client *Client) DescribeRiskLevelsWithChan(request *DescribeRiskLevelsRequest) (<-chan *DescribeRiskLevelsResponse, <-chan error) {
	responseChan := make(chan *DescribeRiskLevelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRiskLevels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRiskLevelsWithCallback invokes the sddp.DescribeRiskLevels API asynchronously
func (client *Client) DescribeRiskLevelsWithCallback(request *DescribeRiskLevelsRequest, callback func(response *DescribeRiskLevelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRiskLevelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRiskLevels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRiskLevelsRequest is the request struct for api DescribeRiskLevels
type DescribeRiskLevelsRequest struct {
	*requests.RpcRequest
	CustomType requests.Integer `position:"Query" name:"CustomType"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	Lang       string           `position:"Query" name:"Lang"`
}

// DescribeRiskLevelsResponse is the response struct for api DescribeRiskLevels
type DescribeRiskLevelsResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	RiskLevelList []RiskLevel `json:"RiskLevelList" xml:"RiskLevelList"`
}

// CreateDescribeRiskLevelsRequest creates a request to invoke DescribeRiskLevels API
func CreateDescribeRiskLevelsRequest() (request *DescribeRiskLevelsRequest) {
	request = &DescribeRiskLevelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeRiskLevels", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRiskLevelsResponse creates a response to parse from DescribeRiskLevels response
func CreateDescribeRiskLevelsResponse() (response *DescribeRiskLevelsResponse) {
	response = &DescribeRiskLevelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
