package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotlineAgentStatus invokes the scsp.GetHotlineAgentStatus API synchronously
func (client *Client) GetHotlineAgentStatus(request *GetHotlineAgentStatusRequest) (response *GetHotlineAgentStatusResponse, err error) {
	response = CreateGetHotlineAgentStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotlineAgentStatusWithChan invokes the scsp.GetHotlineAgentStatus API asynchronously
func (client *Client) GetHotlineAgentStatusWithChan(request *GetHotlineAgentStatusRequest) (<-chan *GetHotlineAgentStatusResponse, <-chan error) {
	responseChan := make(chan *GetHotlineAgentStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotlineAgentStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotlineAgentStatusWithCallback invokes the scsp.GetHotlineAgentStatus API asynchronously
func (client *Client) GetHotlineAgentStatusWithCallback(request *GetHotlineAgentStatusRequest, callback func(response *GetHotlineAgentStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotlineAgentStatusResponse
		var err error
		defer close(result)
		response, err = client.GetHotlineAgentStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotlineAgentStatusRequest is the request struct for api GetHotlineAgentStatus
type GetHotlineAgentStatusRequest struct {
	*requests.RpcRequest
	InstanceId  string `position:"Body"`
	AccountName string `position:"Body"`
}

// GetHotlineAgentStatusResponse is the response struct for api GetHotlineAgentStatus
type GetHotlineAgentStatusResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           string `json:"Data" xml:"Data"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateGetHotlineAgentStatusRequest creates a request to invoke GetHotlineAgentStatus API
func CreateGetHotlineAgentStatusRequest() (request *GetHotlineAgentStatusRequest) {
	request = &GetHotlineAgentStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetHotlineAgentStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHotlineAgentStatusResponse creates a response to parse from GetHotlineAgentStatus response
func CreateGetHotlineAgentStatusResponse() (response *GetHotlineAgentStatusResponse) {
	response = &GetHotlineAgentStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
