package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyRiskCheckStatus invokes the sas.ModifyRiskCheckStatus API synchronously
func (client *Client) ModifyRiskCheckStatus(request *ModifyRiskCheckStatusRequest) (response *ModifyRiskCheckStatusResponse, err error) {
	response = CreateModifyRiskCheckStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyRiskCheckStatusWithChan invokes the sas.ModifyRiskCheckStatus API asynchronously
func (client *Client) ModifyRiskCheckStatusWithChan(request *ModifyRiskCheckStatusRequest) (<-chan *ModifyRiskCheckStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyRiskCheckStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyRiskCheckStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyRiskCheckStatusWithCallback invokes the sas.ModifyRiskCheckStatus API asynchronously
func (client *Client) ModifyRiskCheckStatusWithCallback(request *ModifyRiskCheckStatusRequest, callback func(response *ModifyRiskCheckStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyRiskCheckStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyRiskCheckStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyRiskCheckStatusRequest is the request struct for api ModifyRiskCheckStatus
type ModifyRiskCheckStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ItemId          requests.Integer `position:"Query" name:"ItemId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
	TaskId          requests.Integer `position:"Query" name:"TaskId"`
	Status          string           `position:"Query" name:"Status"`
}

// ModifyRiskCheckStatusResponse is the response struct for api ModifyRiskCheckStatus
type ModifyRiskCheckStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyRiskCheckStatusRequest creates a request to invoke ModifyRiskCheckStatus API
func CreateModifyRiskCheckStatusRequest() (request *ModifyRiskCheckStatusRequest) {
	request = &ModifyRiskCheckStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyRiskCheckStatus", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyRiskCheckStatusResponse creates a response to parse from ModifyRiskCheckStatus response
func CreateModifyRiskCheckStatusResponse() (response *ModifyRiskCheckStatusResponse) {
	response = &ModifyRiskCheckStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
