package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAllEntity invokes the sas.DescribeAllEntity API synchronously
func (client *Client) DescribeAllEntity(request *DescribeAllEntityRequest) (response *DescribeAllEntityResponse, err error) {
	response = CreateDescribeAllEntityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAllEntityWithChan invokes the sas.DescribeAllEntity API asynchronously
func (client *Client) DescribeAllEntityWithChan(request *DescribeAllEntityRequest) (<-chan *DescribeAllEntityResponse, <-chan error) {
	responseChan := make(chan *DescribeAllEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAllEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAllEntityWithCallback invokes the sas.DescribeAllEntity API asynchronously
func (client *Client) DescribeAllEntityWithCallback(request *DescribeAllEntityRequest, callback func(response *DescribeAllEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAllEntityResponse
		var err error
		defer close(result)
		response, err = client.DescribeAllEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAllEntityRequest is the request struct for api DescribeAllEntity
type DescribeAllEntityRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeAllEntityResponse is the response struct for api DescribeAllEntity
type DescribeAllEntityResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	EntityList []Entity `json:"EntityList" xml:"EntityList"`
}

// CreateDescribeAllEntityRequest creates a request to invoke DescribeAllEntity API
func CreateDescribeAllEntityRequest() (request *DescribeAllEntityRequest) {
	request = &DescribeAllEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeAllEntity", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAllEntityResponse creates a response to parse from DescribeAllEntity response
func CreateDescribeAllEntityResponse() (response *DescribeAllEntityResponse) {
	response = &DescribeAllEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
