package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListChangeOrders invokes the sae.ListChangeOrders API synchronously
func (client *Client) ListChangeOrders(request *ListChangeOrdersRequest) (response *ListChangeOrdersResponse, err error) {
	response = CreateListChangeOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// ListChangeOrdersWithChan invokes the sae.ListChangeOrders API asynchronously
func (client *Client) ListChangeOrdersWithChan(request *ListChangeOrdersRequest) (<-chan *ListChangeOrdersResponse, <-chan error) {
	responseChan := make(chan *ListChangeOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListChangeOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListChangeOrdersWithCallback invokes the sae.ListChangeOrders API asynchronously
func (client *Client) ListChangeOrdersWithCallback(request *ListChangeOrdersRequest, callback func(response *ListChangeOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListChangeOrdersResponse
		var err error
		defer close(result)
		response, err = client.ListChangeOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListChangeOrdersRequest is the request struct for api ListChangeOrders
type ListChangeOrdersRequest struct {
	*requests.RoaRequest
	CoType      string           `position:"Query" name:"CoType"`
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	CoStatus    string           `position:"Query" name:"CoStatus"`
	Key         string           `position:"Query" name:"Key"`
}

// ListChangeOrdersResponse is the response struct for api ListChangeOrders
type ListChangeOrdersResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListChangeOrdersRequest creates a request to invoke ListChangeOrders API
func CreateListChangeOrdersRequest() (request *ListChangeOrdersRequest) {
	request = &ListChangeOrdersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "ListChangeOrders", "/pop/v1/sam/changeorder/ListChangeOrders", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListChangeOrdersResponse creates a response to parse from ListChangeOrders response
func CreateListChangeOrdersResponse() (response *ListChangeOrdersResponse) {
	response = &ListChangeOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
