package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchProjectsByRegion invokes the rdc.SearchProjectsByRegion API synchronously
// api document: https://help.aliyun.com/api/rdc/searchprojectsbyregion.html
func (client *Client) SearchProjectsByRegion(request *SearchProjectsByRegionRequest) (response *SearchProjectsByRegionResponse, err error) {
	response = CreateSearchProjectsByRegionResponse()
	err = client.DoAction(request, response)
	return
}

// SearchProjectsByRegionWithChan invokes the rdc.SearchProjectsByRegion API asynchronously
// api document: https://help.aliyun.com/api/rdc/searchprojectsbyregion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchProjectsByRegionWithChan(request *SearchProjectsByRegionRequest) (<-chan *SearchProjectsByRegionResponse, <-chan error) {
	responseChan := make(chan *SearchProjectsByRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchProjectsByRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchProjectsByRegionWithCallback invokes the rdc.SearchProjectsByRegion API asynchronously
// api document: https://help.aliyun.com/api/rdc/searchprojectsbyregion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchProjectsByRegionWithCallback(request *SearchProjectsByRegionRequest, callback func(response *SearchProjectsByRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchProjectsByRegionResponse
		var err error
		defer close(result)
		response, err = client.SearchProjectsByRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchProjectsByRegionRequest is the request struct for api SearchProjectsByRegion
type SearchProjectsByRegionRequest struct {
	*requests.RpcRequest
	CorpIdentifier string           `position:"Query" name:"CorpIdentifier"`
	ToPage         requests.Integer `position:"Query" name:"ToPage"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Region         string           `position:"Query" name:"Region"`
	Status         string           `position:"Query" name:"Status"`
}

// SearchProjectsByRegionResponse is the response struct for api SearchProjectsByRegion
type SearchProjectsByRegionResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateSearchProjectsByRegionRequest creates a request to invoke SearchProjectsByRegion API
func CreateSearchProjectsByRegionRequest() (request *SearchProjectsByRegionRequest) {
	request = &SearchProjectsByRegionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "SearchProjectsByRegion", "rdc", "openAPI")
	return
}

// CreateSearchProjectsByRegionResponse creates a response to parse from SearchProjectsByRegion response
func CreateSearchProjectsByRegionResponse() (response *SearchProjectsByRegionResponse) {
	response = &SearchProjectsByRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
