package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataSetTask invokes the qualitycheck.ListDataSetTask API synchronously
func (client *Client) ListDataSetTask(request *ListDataSetTaskRequest) (response *ListDataSetTaskResponse, err error) {
	response = CreateListDataSetTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataSetTaskWithChan invokes the qualitycheck.ListDataSetTask API asynchronously
func (client *Client) ListDataSetTaskWithChan(request *ListDataSetTaskRequest) (<-chan *ListDataSetTaskResponse, <-chan error) {
	responseChan := make(chan *ListDataSetTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataSetTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataSetTaskWithCallback invokes the qualitycheck.ListDataSetTask API asynchronously
func (client *Client) ListDataSetTaskWithCallback(request *ListDataSetTaskRequest, callback func(response *ListDataSetTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataSetTaskResponse
		var err error
		defer close(result)
		response, err = client.ListDataSetTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataSetTaskRequest is the request struct for api ListDataSetTask
type ListDataSetTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ListDataSetTaskResponse is the response struct for api ListDataSetTask
type ListDataSetTaskResponse struct {
	*responses.BaseResponse
	CurrentPage   int                   `json:"CurrentPage" xml:"CurrentPage"`
	DataSize      int                   `json:"DataSize" xml:"DataSize"`
	RequestId     string                `json:"RequestId" xml:"RequestId"`
	Success       bool                  `json:"Success" xml:"Success"`
	Code          string                `json:"Code" xml:"Code"`
	IsAllcomplete int                   `json:"IsAllcomplete" xml:"IsAllcomplete"`
	Message       string                `json:"Message" xml:"Message"`
	PageSize      int                   `json:"PageSize" xml:"PageSize"`
	TotalCount    int                   `json:"TotalCount" xml:"TotalCount"`
	Data          DataInListDataSetTask `json:"Data" xml:"Data"`
}

// CreateListDataSetTaskRequest creates a request to invoke ListDataSetTask API
func CreateListDataSetTaskRequest() (request *ListDataSetTaskRequest) {
	request = &ListDataSetTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListDataSetTask", "", "")
	request.Method = requests.POST
	return
}

// CreateListDataSetTaskResponse creates a response to parse from ListDataSetTask response
func CreateListDataSetTaskResponse() (response *ListDataSetTaskResponse) {
	response = &ListDataSetTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
