package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetReviewInfo invokes the qualitycheck.GetReviewInfo API synchronously
func (client *Client) GetReviewInfo(request *GetReviewInfoRequest) (response *GetReviewInfoResponse, err error) {
	response = CreateGetReviewInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetReviewInfoWithChan invokes the qualitycheck.GetReviewInfo API asynchronously
func (client *Client) GetReviewInfoWithChan(request *GetReviewInfoRequest) (<-chan *GetReviewInfoResponse, <-chan error) {
	responseChan := make(chan *GetReviewInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetReviewInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetReviewInfoWithCallback invokes the qualitycheck.GetReviewInfo API asynchronously
func (client *Client) GetReviewInfoWithCallback(request *GetReviewInfoRequest, callback func(response *GetReviewInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetReviewInfoResponse
		var err error
		defer close(result)
		response, err = client.GetReviewInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetReviewInfoRequest is the request struct for api GetReviewInfo
type GetReviewInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetReviewInfoResponse is the response struct for api GetReviewInfo
type GetReviewInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetReviewInfoRequest creates a request to invoke GetReviewInfo API
func CreateGetReviewInfoRequest() (request *GetReviewInfoRequest) {
	request = &GetReviewInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetReviewInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetReviewInfoResponse creates a response to parse from GetReviewInfo response
func CreateGetReviewInfoResponse() (response *GetReviewInfoResponse) {
	response = &GetReviewInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
