package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResolverEndpoints invokes the pvtz.DescribeResolverEndpoints API synchronously
func (client *Client) DescribeResolverEndpoints(request *DescribeResolverEndpointsRequest) (response *DescribeResolverEndpointsResponse, err error) {
	response = CreateDescribeResolverEndpointsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResolverEndpointsWithChan invokes the pvtz.DescribeResolverEndpoints API asynchronously
func (client *Client) DescribeResolverEndpointsWithChan(request *DescribeResolverEndpointsRequest) (<-chan *DescribeResolverEndpointsResponse, <-chan error) {
	responseChan := make(chan *DescribeResolverEndpointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResolverEndpoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResolverEndpointsWithCallback invokes the pvtz.DescribeResolverEndpoints API asynchronously
func (client *Client) DescribeResolverEndpointsWithCallback(request *DescribeResolverEndpointsRequest, callback func(response *DescribeResolverEndpointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResolverEndpointsResponse
		var err error
		defer close(result)
		response, err = client.DescribeResolverEndpoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResolverEndpointsRequest is the request struct for api DescribeResolverEndpoints
type DescribeResolverEndpointsRequest struct {
	*requests.RpcRequest
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	Keyword      string           `position:"Query" name:"Keyword"`
	Lang         string           `position:"Query" name:"Lang"`
	Status       string           `position:"Query" name:"Status"`
}

// DescribeResolverEndpointsResponse is the response struct for api DescribeResolverEndpoints
type DescribeResolverEndpointsResponse struct {
	*responses.BaseResponse
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	TotalPages int        `json:"TotalPages" xml:"TotalPages"`
	TotalItems int        `json:"TotalItems" xml:"TotalItems"`
	Endpoints  []Endpoint `json:"Endpoints" xml:"Endpoints"`
}

// CreateDescribeResolverEndpointsRequest creates a request to invoke DescribeResolverEndpoints API
func CreateDescribeResolverEndpointsRequest() (request *DescribeResolverEndpointsRequest) {
	request = &DescribeResolverEndpointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeResolverEndpoints", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeResolverEndpointsResponse creates a response to parse from DescribeResolverEndpoints response
func CreateDescribeResolverEndpointsResponse() (response *DescribeResolverEndpointsResponse) {
	response = &DescribeResolverEndpointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
