package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterMonitor invokes the polardb.DescribeDBClusterMonitor API synchronously
func (client *Client) DescribeDBClusterMonitor(request *DescribeDBClusterMonitorRequest) (response *DescribeDBClusterMonitorResponse, err error) {
	response = CreateDescribeDBClusterMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterMonitorWithChan invokes the polardb.DescribeDBClusterMonitor API asynchronously
func (client *Client) DescribeDBClusterMonitorWithChan(request *DescribeDBClusterMonitorRequest) (<-chan *DescribeDBClusterMonitorResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterMonitorWithCallback invokes the polardb.DescribeDBClusterMonitor API asynchronously
func (client *Client) DescribeDBClusterMonitorWithCallback(request *DescribeDBClusterMonitorRequest, callback func(response *DescribeDBClusterMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterMonitorResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterMonitorRequest is the request struct for api DescribeDBClusterMonitor
type DescribeDBClusterMonitorRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterMonitorResponse is the response struct for api DescribeDBClusterMonitor
type DescribeDBClusterMonitorResponse struct {
	*responses.BaseResponse
	Period    string `json:"Period" xml:"Period"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeDBClusterMonitorRequest creates a request to invoke DescribeDBClusterMonitor API
func CreateDescribeDBClusterMonitorRequest() (request *DescribeDBClusterMonitorRequest) {
	request = &DescribeDBClusterMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBClusterMonitor", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterMonitorResponse creates a response to parse from DescribeDBClusterMonitor response
func CreateDescribeDBClusterMonitorResponse() (response *DescribeDBClusterMonitorResponse) {
	response = &DescribeDBClusterMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
