package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishScriptForDebug invokes the outboundbot.PublishScriptForDebug API synchronously
func (client *Client) PublishScriptForDebug(request *PublishScriptForDebugRequest) (response *PublishScriptForDebugResponse, err error) {
	response = CreatePublishScriptForDebugResponse()
	err = client.DoAction(request, response)
	return
}

// PublishScriptForDebugWithChan invokes the outboundbot.PublishScriptForDebug API asynchronously
func (client *Client) PublishScriptForDebugWithChan(request *PublishScriptForDebugRequest) (<-chan *PublishScriptForDebugResponse, <-chan error) {
	responseChan := make(chan *PublishScriptForDebugResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishScriptForDebug(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishScriptForDebugWithCallback invokes the outboundbot.PublishScriptForDebug API asynchronously
func (client *Client) PublishScriptForDebugWithCallback(request *PublishScriptForDebugRequest, callback func(response *PublishScriptForDebugResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishScriptForDebugResponse
		var err error
		defer close(result)
		response, err = client.PublishScriptForDebug(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishScriptForDebugRequest is the request struct for api PublishScriptForDebug
type PublishScriptForDebugRequest struct {
	*requests.RpcRequest
	ScriptId   string `position:"Query" name:"ScriptId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// PublishScriptForDebugResponse is the response struct for api PublishScriptForDebug
type PublishScriptForDebugResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreatePublishScriptForDebugRequest creates a request to invoke PublishScriptForDebug API
func CreatePublishScriptForDebugRequest() (request *PublishScriptForDebugRequest) {
	request = &PublishScriptForDebugRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "PublishScriptForDebug", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePublishScriptForDebugResponse creates a response to parse from PublishScriptForDebug response
func CreatePublishScriptForDebugResponse() (response *PublishScriptForDebugResponse) {
	response = &PublishScriptForDebugResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
