package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertInstance invokes the ots.InsertInstance API synchronously
// api document: https://help.aliyun.com/api/ots/insertinstance.html
func (client *Client) InsertInstance(request *InsertInstanceRequest) (response *InsertInstanceResponse, err error) {
	response = CreateInsertInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// InsertInstanceWithChan invokes the ots.InsertInstance API asynchronously
// api document: https://help.aliyun.com/api/ots/insertinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertInstanceWithChan(request *InsertInstanceRequest) (<-chan *InsertInstanceResponse, <-chan error) {
	responseChan := make(chan *InsertInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertInstanceWithCallback invokes the ots.InsertInstance API asynchronously
// api document: https://help.aliyun.com/api/ots/insertinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InsertInstanceWithCallback(request *InsertInstanceRequest, callback func(response *InsertInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertInstanceResponse
		var err error
		defer close(result)
		response, err = client.InsertInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertInstanceRequest is the request struct for api InsertInstance
type InsertInstanceRequest struct {
	*requests.RpcRequest
	AccessKeyId     string                   `position:"Query" name:"access_key_id"`
	ClusterType     string                   `position:"Query" name:"ClusterType"`
	ResourceOwnerId requests.Integer         `position:"Query" name:"ResourceOwnerId"`
	InstanceName    string                   `position:"Query" name:"InstanceName"`
	Description     string                   `position:"Query" name:"Description"`
	TagInfo         *[]InsertInstanceTagInfo `position:"Query" name:"TagInfo"  type:"Repeated"`
	Network         string                   `position:"Query" name:"Network"`
}

// InsertInstanceTagInfo is a repeated param struct in InsertInstanceRequest
type InsertInstanceTagInfo struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// InsertInstanceResponse is the response struct for api InsertInstance
type InsertInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInsertInstanceRequest creates a request to invoke InsertInstance API
func CreateInsertInstanceRequest() (request *InsertInstanceRequest) {
	request = &InsertInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ots", "2016-06-20", "InsertInstance", "ots", "openAPI")
	return
}

// CreateInsertInstanceResponse creates a response to parse from InsertInstance response
func CreateInsertInstanceResponse() (response *InsertInstanceResponse) {
	response = &InsertInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
