package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApp invokes the opensearch.DescribeApp API synchronously
func (client *Client) DescribeApp(request *DescribeAppRequest) (response *DescribeAppResponse, err error) {
	response = CreateDescribeAppResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppWithChan invokes the opensearch.DescribeApp API asynchronously
func (client *Client) DescribeAppWithChan(request *DescribeAppRequest) (<-chan *DescribeAppResponse, <-chan error) {
	responseChan := make(chan *DescribeAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppWithCallback invokes the opensearch.DescribeApp API asynchronously
func (client *Client) DescribeAppWithCallback(request *DescribeAppRequest, callback func(response *DescribeAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppResponse
		var err error
		defer close(result)
		response, err = client.DescribeApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppRequest is the request struct for api DescribeApp
type DescribeAppRequest struct {
	*requests.RoaRequest
	AppId            requests.Integer `position:"Path" name:"appId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// DescribeAppResponse is the response struct for api DescribeApp
type DescribeAppResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"requestId" xml:"requestId"`
	Result    ResultInDescribeApp `json:"result" xml:"result"`
}

// CreateDescribeAppRequest creates a request to invoke DescribeApp API
func CreateDescribeAppRequest() (request *DescribeAppRequest) {
	request = &DescribeAppRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DescribeApp", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeAppResponse creates a response to parse from DescribeApp response
func CreateDescribeAppResponse() (response *DescribeAppResponse) {
	response = &DescribeAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
