package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListParameters invokes the oos.ListParameters API synchronously
func (client *Client) ListParameters(request *ListParametersRequest) (response *ListParametersResponse, err error) {
	response = CreateListParametersResponse()
	err = client.DoAction(request, response)
	return
}

// ListParametersWithChan invokes the oos.ListParameters API asynchronously
func (client *Client) ListParametersWithChan(request *ListParametersRequest) (<-chan *ListParametersResponse, <-chan error) {
	responseChan := make(chan *ListParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListParametersWithCallback invokes the oos.ListParameters API asynchronously
func (client *Client) ListParametersWithCallback(request *ListParametersRequest, callback func(response *ListParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListParametersResponse
		var err error
		defer close(result)
		response, err = client.ListParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListParametersRequest is the request struct for api ListParameters
type ListParametersRequest struct {
	*requests.RpcRequest
	Type       string           `position:"Query" name:"Type"`
	Recursive  requests.Boolean `position:"Query" name:"Recursive"`
	Path       string           `position:"Query" name:"Path"`
	NextToken  string           `position:"Query" name:"NextToken"`
	SortOrder  string           `position:"Query" name:"SortOrder"`
	Tags       string           `position:"Query" name:"Tags"`
	Name       string           `position:"Query" name:"Name"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	SortField  string           `position:"Query" name:"SortField"`
}

// ListParametersResponse is the response struct for api ListParameters
type ListParametersResponse struct {
	*responses.BaseResponse
	RequestId  string                      `json:"RequestId" xml:"RequestId"`
	MaxResults int                         `json:"MaxResults" xml:"MaxResults"`
	NextToken  string                      `json:"NextToken" xml:"NextToken"`
	TotalCount int                         `json:"TotalCount" xml:"TotalCount"`
	Parameters []ParameterInListParameters `json:"Parameters" xml:"Parameters"`
}

// CreateListParametersRequest creates a request to invoke ListParameters API
func CreateListParametersRequest() (request *ListParametersRequest) {
	request = &ListParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListParameters", "", "")
	request.Method = requests.POST
	return
}

// CreateListParametersResponse creates a response to parse from ListParameters response
func CreateListParametersResponse() (response *ListParametersResponse) {
	response = &ListParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
