package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMTInterveneWord invokes the nlp_automl.AddMTInterveneWord API synchronously
func (client *Client) AddMTInterveneWord(request *AddMTInterveneWordRequest) (response *AddMTInterveneWordResponse, err error) {
	response = CreateAddMTInterveneWordResponse()
	err = client.DoAction(request, response)
	return
}

// AddMTInterveneWordWithChan invokes the nlp_automl.AddMTInterveneWord API asynchronously
func (client *Client) AddMTInterveneWordWithChan(request *AddMTInterveneWordRequest) (<-chan *AddMTInterveneWordResponse, <-chan error) {
	responseChan := make(chan *AddMTInterveneWordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMTInterveneWord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMTInterveneWordWithCallback invokes the nlp_automl.AddMTInterveneWord API asynchronously
func (client *Client) AddMTInterveneWordWithCallback(request *AddMTInterveneWordRequest, callback func(response *AddMTInterveneWordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMTInterveneWordResponse
		var err error
		defer close(result)
		response, err = client.AddMTInterveneWord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMTInterveneWordRequest is the request struct for api AddMTInterveneWord
type AddMTInterveneWordRequest struct {
	*requests.RpcRequest
	Product    string           `position:"Query" name:"Product"`
	SourceText string           `position:"Query" name:"SourceText"`
	PackageId  string           `position:"Query" name:"PackageId"`
	TargetText string           `position:"Query" name:"TargetText"`
	TenantId   requests.Integer `position:"Query" name:"TenantId"`
	ProjectId  string           `position:"Query" name:"ProjectId"`
}

// AddMTInterveneWordResponse is the response struct for api AddMTInterveneWord
type AddMTInterveneWordResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   int    `json:"Message" xml:"Message"`
	WordId    string `json:"WordId" xml:"WordId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddMTInterveneWordRequest creates a request to invoke AddMTInterveneWord API
func CreateAddMTInterveneWordRequest() (request *AddMTInterveneWordRequest) {
	request = &AddMTInterveneWordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-07-01", "AddMTInterveneWord", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddMTInterveneWordResponse creates a response to parse from AddMTInterveneWord response
func CreateAddMTInterveneWordResponse() (response *AddMTInterveneWordResponse) {
	response = &AddMTInterveneWordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
