package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMountTarget invokes the nas.ModifyMountTarget API synchronously
func (client *Client) ModifyMountTarget(request *ModifyMountTargetRequest) (response *ModifyMountTargetResponse, err error) {
	response = CreateModifyMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMountTargetWithChan invokes the nas.ModifyMountTarget API asynchronously
func (client *Client) ModifyMountTargetWithChan(request *ModifyMountTargetRequest) (<-chan *ModifyMountTargetResponse, <-chan error) {
	responseChan := make(chan *ModifyMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMountTargetWithCallback invokes the nas.ModifyMountTarget API asynchronously
func (client *Client) ModifyMountTargetWithCallback(request *ModifyMountTargetRequest, callback func(response *ModifyMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMountTargetResponse
		var err error
		defer close(result)
		response, err = client.ModifyMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMountTargetRequest is the request struct for api ModifyMountTarget
type ModifyMountTargetRequest struct {
	*requests.RpcRequest
	FileSystemId               string `position:"Query" name:"FileSystemId"`
	MountTargetDomain          string `position:"Query" name:"MountTargetDomain"`
	AccessGroupName            string `position:"Query" name:"AccessGroupName"`
	DualStackMountTargetDomain string `position:"Query" name:"DualStackMountTargetDomain"`
	Status                     string `position:"Query" name:"Status"`
}

// ModifyMountTargetResponse is the response struct for api ModifyMountTarget
type ModifyMountTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyMountTargetRequest creates a request to invoke ModifyMountTarget API
func CreateModifyMountTargetRequest() (request *ModifyMountTargetRequest) {
	request = &ModifyMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "ModifyMountTarget", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyMountTargetResponse creates a response to parse from ModifyMountTarget response
func CreateModifyMountTargetResponse() (response *ModifyMountTargetResponse) {
	response = &ModifyMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
