package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIProductionJobList invokes the mts.QueryIProductionJobList API synchronously
func (client *Client) QueryIProductionJobList(request *QueryIProductionJobListRequest) (response *QueryIProductionJobListResponse, err error) {
	response = CreateQueryIProductionJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIProductionJobListWithChan invokes the mts.QueryIProductionJobList API asynchronously
func (client *Client) QueryIProductionJobListWithChan(request *QueryIProductionJobListRequest) (<-chan *QueryIProductionJobListResponse, <-chan error) {
	responseChan := make(chan *QueryIProductionJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIProductionJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIProductionJobListWithCallback invokes the mts.QueryIProductionJobList API asynchronously
func (client *Client) QueryIProductionJobListWithCallback(request *QueryIProductionJobListRequest, callback func(response *QueryIProductionJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIProductionJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryIProductionJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIProductionJobListRequest is the request struct for api QueryIProductionJobList
type QueryIProductionJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	IProductionJobIds    string           `position:"Query" name:"IProductionJobIds"`
}

// QueryIProductionJobListResponse is the response struct for api QueryIProductionJobList
type QueryIProductionJobListResponse struct {
	*responses.BaseResponse
	RequestId     string                               `json:"RequestId" xml:"RequestId"`
	NextPageToken string                               `json:"NextPageToken" xml:"NextPageToken"`
	Jobs          JobsInQueryIProductionJobList        `json:"Jobs" xml:"Jobs"`
	NonExistIds   NonExistIdsInQueryIProductionJobList `json:"NonExistIds" xml:"NonExistIds"`
}

// CreateQueryIProductionJobListRequest creates a request to invoke QueryIProductionJobList API
func CreateQueryIProductionJobListRequest() (request *QueryIProductionJobListRequest) {
	request = &QueryIProductionJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryIProductionJobList", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryIProductionJobListResponse creates a response to parse from QueryIProductionJobList response
func CreateQueryIProductionJobListResponse() (response *QueryIProductionJobListResponse) {
	response = &QueryIProductionJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
