package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateZnode invokes the mse.UpdateZnode API synchronously
func (client *Client) UpdateZnode(request *UpdateZnodeRequest) (response *UpdateZnodeResponse, err error) {
	response = CreateUpdateZnodeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateZnodeWithChan invokes the mse.UpdateZnode API asynchronously
func (client *Client) UpdateZnodeWithChan(request *UpdateZnodeRequest) (<-chan *UpdateZnodeResponse, <-chan error) {
	responseChan := make(chan *UpdateZnodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateZnode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateZnodeWithCallback invokes the mse.UpdateZnode API asynchronously
func (client *Client) UpdateZnodeWithCallback(request *UpdateZnodeRequest, callback func(response *UpdateZnodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateZnodeResponse
		var err error
		defer close(result)
		response, err = client.UpdateZnode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateZnodeRequest is the request struct for api UpdateZnode
type UpdateZnodeRequest struct {
	*requests.RpcRequest
	Data           string `position:"Query" name:"Data"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	Path           string `position:"Query" name:"Path"`
	RequestPars    string `position:"Query" name:"RequestPars"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// UpdateZnodeResponse is the response struct for api UpdateZnode
type UpdateZnodeResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateZnodeRequest creates a request to invoke UpdateZnode API
func CreateUpdateZnodeRequest() (request *UpdateZnodeRequest) {
	request = &UpdateZnodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateZnode", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateZnodeResponse creates a response to parse from UpdateZnode response
func CreateUpdateZnodeResponse() (response *UpdateZnodeResponse) {
	response = &UpdateZnodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
