package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGovernanceKubernetesClusterList invokes the mse.GetGovernanceKubernetesClusterList API synchronously
func (client *Client) GetGovernanceKubernetesClusterList(request *GetGovernanceKubernetesClusterListRequest) (response *GetGovernanceKubernetesClusterListResponse, err error) {
	response = CreateGetGovernanceKubernetesClusterListResponse()
	err = client.DoAction(request, response)
	return
}

// GetGovernanceKubernetesClusterListWithChan invokes the mse.GetGovernanceKubernetesClusterList API asynchronously
func (client *Client) GetGovernanceKubernetesClusterListWithChan(request *GetGovernanceKubernetesClusterListRequest) (<-chan *GetGovernanceKubernetesClusterListResponse, <-chan error) {
	responseChan := make(chan *GetGovernanceKubernetesClusterListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGovernanceKubernetesClusterList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGovernanceKubernetesClusterListWithCallback invokes the mse.GetGovernanceKubernetesClusterList API asynchronously
func (client *Client) GetGovernanceKubernetesClusterListWithCallback(request *GetGovernanceKubernetesClusterListRequest, callback func(response *GetGovernanceKubernetesClusterListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGovernanceKubernetesClusterListResponse
		var err error
		defer close(result)
		response, err = client.GetGovernanceKubernetesClusterList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGovernanceKubernetesClusterListRequest is the request struct for api GetGovernanceKubernetesClusterList
type GetGovernanceKubernetesClusterListRequest struct {
	*requests.RpcRequest
	ClusterName    string           `position:"Query" name:"ClusterName"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// GetGovernanceKubernetesClusterListResponse is the response struct for api GetGovernanceKubernetesClusterList
type GetGovernanceKubernetesClusterListResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetGovernanceKubernetesClusterListRequest creates a request to invoke GetGovernanceKubernetesClusterList API
func CreateGetGovernanceKubernetesClusterListRequest() (request *GetGovernanceKubernetesClusterListRequest) {
	request = &GetGovernanceKubernetesClusterListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetGovernanceKubernetesClusterList", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGovernanceKubernetesClusterListResponse creates a response to parse from GetGovernanceKubernetesClusterList response
func CreateGetGovernanceKubernetesClusterListResponse() (response *GetGovernanceKubernetesClusterListResponse) {
	response = &GetGovernanceKubernetesClusterListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
