package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServiceSource invokes the mse.DeleteServiceSource API synchronously
func (client *Client) DeleteServiceSource(request *DeleteServiceSourceRequest) (response *DeleteServiceSourceResponse, err error) {
	response = CreateDeleteServiceSourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServiceSourceWithChan invokes the mse.DeleteServiceSource API asynchronously
func (client *Client) DeleteServiceSourceWithChan(request *DeleteServiceSourceRequest) (<-chan *DeleteServiceSourceResponse, <-chan error) {
	responseChan := make(chan *DeleteServiceSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServiceSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServiceSourceWithCallback invokes the mse.DeleteServiceSource API asynchronously
func (client *Client) DeleteServiceSourceWithCallback(request *DeleteServiceSourceRequest, callback func(response *DeleteServiceSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServiceSourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteServiceSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServiceSourceRequest is the request struct for api DeleteServiceSource
type DeleteServiceSourceRequest struct {
	*requests.RpcRequest
	SourceId        requests.Integer `position:"Query" name:"SourceId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// DeleteServiceSourceResponse is the response struct for api DeleteServiceSource
type DeleteServiceSourceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeleteServiceSourceRequest creates a request to invoke DeleteServiceSource API
func CreateDeleteServiceSourceRequest() (request *DeleteServiceSourceRequest) {
	request = &DeleteServiceSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteServiceSource", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDeleteServiceSourceResponse creates a response to parse from DeleteServiceSource response
func CreateDeleteServiceSourceResponse() (response *DeleteServiceSourceResponse) {
	response = &DeleteServiceSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
