package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewaySlb invokes the mse.DeleteGatewaySlb API synchronously
func (client *Client) DeleteGatewaySlb(request *DeleteGatewaySlbRequest) (response *DeleteGatewaySlbResponse, err error) {
	response = CreateDeleteGatewaySlbResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewaySlbWithChan invokes the mse.DeleteGatewaySlb API asynchronously
func (client *Client) DeleteGatewaySlbWithChan(request *DeleteGatewaySlbRequest) (<-chan *DeleteGatewaySlbResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewaySlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewaySlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewaySlbWithCallback invokes the mse.DeleteGatewaySlb API asynchronously
func (client *Client) DeleteGatewaySlbWithCallback(request *DeleteGatewaySlbRequest, callback func(response *DeleteGatewaySlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewaySlbResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewaySlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewaySlbRequest is the request struct for api DeleteGatewaySlb
type DeleteGatewaySlbRequest struct {
	*requests.RpcRequest
	DeleteSlb       requests.Boolean `position:"Query" name:"DeleteSlb"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	Id              string           `position:"Query" name:"Id"`
}

// DeleteGatewaySlbResponse is the response struct for api DeleteGatewaySlb
type DeleteGatewaySlbResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateDeleteGatewaySlbRequest creates a request to invoke DeleteGatewaySlb API
func CreateDeleteGatewaySlbRequest() (request *DeleteGatewaySlbRequest) {
	request = &DeleteGatewaySlbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteGatewaySlb", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDeleteGatewaySlbResponse creates a response to parse from DeleteGatewaySlb response
func CreateDeleteGatewaySlbResponse() (response *DeleteGatewaySlbResponse) {
	response = &DeleteGatewaySlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
