package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLiveDomainStagingConfig invokes the live.SetLiveDomainStagingConfig API synchronously
func (client *Client) SetLiveDomainStagingConfig(request *SetLiveDomainStagingConfigRequest) (response *SetLiveDomainStagingConfigResponse, err error) {
	response = CreateSetLiveDomainStagingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetLiveDomainStagingConfigWithChan invokes the live.SetLiveDomainStagingConfig API asynchronously
func (client *Client) SetLiveDomainStagingConfigWithChan(request *SetLiveDomainStagingConfigRequest) (<-chan *SetLiveDomainStagingConfigResponse, <-chan error) {
	responseChan := make(chan *SetLiveDomainStagingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLiveDomainStagingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLiveDomainStagingConfigWithCallback invokes the live.SetLiveDomainStagingConfig API asynchronously
func (client *Client) SetLiveDomainStagingConfigWithCallback(request *SetLiveDomainStagingConfigRequest, callback func(response *SetLiveDomainStagingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLiveDomainStagingConfigResponse
		var err error
		defer close(result)
		response, err = client.SetLiveDomainStagingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLiveDomainStagingConfigRequest is the request struct for api SetLiveDomainStagingConfig
type SetLiveDomainStagingConfigRequest struct {
	*requests.RpcRequest
	Functions  string           `position:"Query" name:"Functions"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// SetLiveDomainStagingConfigResponse is the response struct for api SetLiveDomainStagingConfig
type SetLiveDomainStagingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLiveDomainStagingConfigRequest creates a request to invoke SetLiveDomainStagingConfig API
func CreateSetLiveDomainStagingConfigRequest() (request *SetLiveDomainStagingConfigRequest) {
	request = &SetLiveDomainStagingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetLiveDomainStagingConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetLiveDomainStagingConfigResponse creates a response to parse from SetLiveDomainStagingConfig response
func CreateSetLiveDomainStagingConfigResponse() (response *SetLiveDomainStagingConfigResponse) {
	response = &SetLiveDomainStagingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
