package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomTemplate invokes the live.DeleteCustomTemplate API synchronously
func (client *Client) DeleteCustomTemplate(request *DeleteCustomTemplateRequest) (response *DeleteCustomTemplateResponse, err error) {
	response = CreateDeleteCustomTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomTemplateWithChan invokes the live.DeleteCustomTemplate API asynchronously
func (client *Client) DeleteCustomTemplateWithChan(request *DeleteCustomTemplateRequest) (<-chan *DeleteCustomTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomTemplateWithCallback invokes the live.DeleteCustomTemplate API asynchronously
func (client *Client) DeleteCustomTemplateWithCallback(request *DeleteCustomTemplateRequest, callback func(response *DeleteCustomTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomTemplateRequest is the request struct for api DeleteCustomTemplate
type DeleteCustomTemplateRequest struct {
	*requests.RpcRequest
	Template string           `position:"Query" name:"Template"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCustomTemplateResponse is the response struct for api DeleteCustomTemplate
type DeleteCustomTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomTemplateRequest creates a request to invoke DeleteCustomTemplate API
func CreateDeleteCustomTemplateRequest() (request *DeleteCustomTemplateRequest) {
	request = &DeleteCustomTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteCustomTemplate", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomTemplateResponse creates a response to parse from DeleteCustomTemplate response
func CreateDeleteCustomTemplateResponse() (response *DeleteCustomTemplateResponse) {
	response = &DeleteCustomTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
