package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveRecordNotifyConfig invokes the live.AddLiveRecordNotifyConfig API synchronously
func (client *Client) AddLiveRecordNotifyConfig(request *AddLiveRecordNotifyConfigRequest) (response *AddLiveRecordNotifyConfigResponse, err error) {
	response = CreateAddLiveRecordNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveRecordNotifyConfigWithChan invokes the live.AddLiveRecordNotifyConfig API asynchronously
func (client *Client) AddLiveRecordNotifyConfigWithChan(request *AddLiveRecordNotifyConfigRequest) (<-chan *AddLiveRecordNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *AddLiveRecordNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveRecordNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveRecordNotifyConfigWithCallback invokes the live.AddLiveRecordNotifyConfig API asynchronously
func (client *Client) AddLiveRecordNotifyConfigWithCallback(request *AddLiveRecordNotifyConfigRequest, callback func(response *AddLiveRecordNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveRecordNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLiveRecordNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveRecordNotifyConfigRequest is the request struct for api AddLiveRecordNotifyConfig
type AddLiveRecordNotifyConfigRequest struct {
	*requests.RpcRequest
	OnDemandUrl      string           `position:"Query" name:"OnDemandUrl"`
	SecurityToken    string           `position:"Query" name:"SecurityToken"`
	NotifyUrl        string           `position:"Query" name:"NotifyUrl"`
	NeedStatusNotify requests.Boolean `position:"Query" name:"NeedStatusNotify"`
	DomainName       string           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
}

// AddLiveRecordNotifyConfigResponse is the response struct for api AddLiveRecordNotifyConfig
type AddLiveRecordNotifyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveRecordNotifyConfigRequest creates a request to invoke AddLiveRecordNotifyConfig API
func CreateAddLiveRecordNotifyConfigRequest() (request *AddLiveRecordNotifyConfigRequest) {
	request = &AddLiveRecordNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveRecordNotifyConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveRecordNotifyConfigResponse creates a response to parse from AddLiveRecordNotifyConfig response
func CreateAddLiveRecordNotifyConfigResponse() (response *AddLiveRecordNotifyConfigResponse) {
	response = &AddLiveRecordNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
