package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNodeEnablingState invokes the linkwan.UpdateNodeEnablingState API synchronously
func (client *Client) UpdateNodeEnablingState(request *UpdateNodeEnablingStateRequest) (response *UpdateNodeEnablingStateResponse, err error) {
	response = CreateUpdateNodeEnablingStateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNodeEnablingStateWithChan invokes the linkwan.UpdateNodeEnablingState API asynchronously
func (client *Client) UpdateNodeEnablingStateWithChan(request *UpdateNodeEnablingStateRequest) (<-chan *UpdateNodeEnablingStateResponse, <-chan error) {
	responseChan := make(chan *UpdateNodeEnablingStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNodeEnablingState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNodeEnablingStateWithCallback invokes the linkwan.UpdateNodeEnablingState API asynchronously
func (client *Client) UpdateNodeEnablingStateWithCallback(request *UpdateNodeEnablingStateRequest, callback func(response *UpdateNodeEnablingStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNodeEnablingStateResponse
		var err error
		defer close(result)
		response, err = client.UpdateNodeEnablingState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNodeEnablingStateRequest is the request struct for api UpdateNodeEnablingState
type UpdateNodeEnablingStateRequest struct {
	*requests.RpcRequest
	DevEui      string           `position:"Query" name:"DevEui"`
	IsEnable    requests.Boolean `position:"Query" name:"IsEnable"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// UpdateNodeEnablingStateResponse is the response struct for api UpdateNodeEnablingState
type UpdateNodeEnablingStateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateNodeEnablingStateRequest creates a request to invoke UpdateNodeEnablingState API
func CreateUpdateNodeEnablingStateRequest() (request *UpdateNodeEnablingStateRequest) {
	request = &UpdateNodeEnablingStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateNodeEnablingState", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateNodeEnablingStateResponse creates a response to parse from UpdateNodeEnablingState response
func CreateUpdateNodeEnablingStateResponse() (response *UpdateNodeEnablingStateResponse) {
	response = &UpdateNodeEnablingStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
