package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOwnedJoinPermissions invokes the linkwan.ListOwnedJoinPermissions API synchronously
func (client *Client) ListOwnedJoinPermissions(request *ListOwnedJoinPermissionsRequest) (response *ListOwnedJoinPermissionsResponse, err error) {
	response = CreateListOwnedJoinPermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListOwnedJoinPermissionsWithChan invokes the linkwan.ListOwnedJoinPermissions API asynchronously
func (client *Client) ListOwnedJoinPermissionsWithChan(request *ListOwnedJoinPermissionsRequest) (<-chan *ListOwnedJoinPermissionsResponse, <-chan error) {
	responseChan := make(chan *ListOwnedJoinPermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOwnedJoinPermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOwnedJoinPermissionsWithCallback invokes the linkwan.ListOwnedJoinPermissions API asynchronously
func (client *Client) ListOwnedJoinPermissionsWithCallback(request *ListOwnedJoinPermissionsRequest, callback func(response *ListOwnedJoinPermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOwnedJoinPermissionsResponse
		var err error
		defer close(result)
		response, err = client.ListOwnedJoinPermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOwnedJoinPermissionsRequest is the request struct for api ListOwnedJoinPermissions
type ListOwnedJoinPermissionsRequest struct {
	*requests.RpcRequest
	Enabled                 requests.Boolean `position:"Query" name:"Enabled"`
	IotInstanceId           string           `position:"Query" name:"IotInstanceId"`
	FuzzyJoinEui            string           `position:"Query" name:"FuzzyJoinEui"`
	Limit                   requests.Integer `position:"Query" name:"Limit"`
	FuzzyJoinPermissionName string           `position:"Query" name:"FuzzyJoinPermissionName"`
	Offset                  requests.Integer `position:"Query" name:"Offset"`
	FuzzyRenterAliyunId     string           `position:"Query" name:"FuzzyRenterAliyunId"`
	Ascending               requests.Boolean `position:"Query" name:"Ascending"`
	ApiProduct              string           `position:"Body" name:"ApiProduct"`
	ApiRevision             string           `position:"Body" name:"ApiRevision"`
	SortingField            string           `position:"Query" name:"SortingField"`
}

// ListOwnedJoinPermissionsResponse is the response struct for api ListOwnedJoinPermissions
type ListOwnedJoinPermissionsResponse struct {
	*responses.BaseResponse
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Success   bool                           `json:"Success" xml:"Success"`
	Data      DataInListOwnedJoinPermissions `json:"Data" xml:"Data"`
}

// CreateListOwnedJoinPermissionsRequest creates a request to invoke ListOwnedJoinPermissions API
func CreateListOwnedJoinPermissionsRequest() (request *ListOwnedJoinPermissionsRequest) {
	request = &ListOwnedJoinPermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListOwnedJoinPermissions", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOwnedJoinPermissionsResponse creates a response to parse from ListOwnedJoinPermissions response
func CreateListOwnedJoinPermissionsResponse() (response *ListOwnedJoinPermissionsResponse) {
	response = &ListOwnedJoinPermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
