package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEcsListPage invokes the jarvis.DescribeEcsListPage API synchronously
// api document: https://help.aliyun.com/api/jarvis/describeecslistpage.html
func (client *Client) DescribeEcsListPage(request *DescribeEcsListPageRequest) (response *DescribeEcsListPageResponse, err error) {
	response = CreateDescribeEcsListPageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEcsListPageWithChan invokes the jarvis.DescribeEcsListPage API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeecslistpage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEcsListPageWithChan(request *DescribeEcsListPageRequest) (<-chan *DescribeEcsListPageResponse, <-chan error) {
	responseChan := make(chan *DescribeEcsListPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEcsListPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEcsListPageWithCallback invokes the jarvis.DescribeEcsListPage API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeecslistpage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEcsListPageWithCallback(request *DescribeEcsListPageRequest, callback func(response *DescribeEcsListPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEcsListPageResponse
		var err error
		defer close(result)
		response, err = client.DescribeEcsListPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEcsListPageRequest is the request struct for api DescribeEcsListPage
type DescribeEcsListPageRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
	SourceCode  string           `position:"Query" name:"SourceCode"`
}

// DescribeEcsListPageResponse is the response struct for api DescribeEcsListPage
type DescribeEcsListPageResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Module    string   `json:"module" xml:"module"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeEcsListPageRequest creates a request to invoke DescribeEcsListPage API
func CreateDescribeEcsListPageRequest() (request *DescribeEcsListPageRequest) {
	request = &DescribeEcsListPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeEcsListPage", "jarvis", "openAPI")
	return
}

// CreateDescribeEcsListPageResponse creates a response to parse from DescribeEcsListPage response
func CreateDescribeEcsListPageResponse() (response *DescribeEcsListPageResponse) {
	response = &DescribeEcsListPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
