package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIPSegment invokes the itaas.UpdateIPSegment API synchronously
// api document: https://help.aliyun.com/api/itaas/updateipsegment.html
func (client *Client) UpdateIPSegment(request *UpdateIPSegmentRequest) (response *UpdateIPSegmentResponse, err error) {
	response = CreateUpdateIPSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIPSegmentWithChan invokes the itaas.UpdateIPSegment API asynchronously
// api document: https://help.aliyun.com/api/itaas/updateipsegment.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateIPSegmentWithChan(request *UpdateIPSegmentRequest) (<-chan *UpdateIPSegmentResponse, <-chan error) {
	responseChan := make(chan *UpdateIPSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIPSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIPSegmentWithCallback invokes the itaas.UpdateIPSegment API asynchronously
// api document: https://help.aliyun.com/api/itaas/updateipsegment.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateIPSegmentWithCallback(request *UpdateIPSegmentRequest, callback func(response *UpdateIPSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIPSegmentResponse
		var err error
		defer close(result)
		response, err = client.UpdateIPSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIPSegmentRequest is the request struct for api UpdateIPSegment
type UpdateIPSegmentRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Ipsegment   string `position:"Query" name:"Ipsegment"`
	Memo        string `position:"Query" name:"Memo"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Uuid        string `position:"Query" name:"Uuid"`
	Operator    string `position:"Query" name:"Operator"`
}

// UpdateIPSegmentResponse is the response struct for api UpdateIPSegment
type UpdateIPSegmentResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	ErrorCode int                        `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                     `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                       `json:"Success" xml:"Success"`
	ErrorList ErrorListInUpdateIPSegment `json:"ErrorList" xml:"ErrorList"`
}

// CreateUpdateIPSegmentRequest creates a request to invoke UpdateIPSegment API
func CreateUpdateIPSegmentRequest() (request *UpdateIPSegmentRequest) {
	request = &UpdateIPSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "UpdateIPSegment", "itaas", "openAPI")
	return
}

// CreateUpdateIPSegmentResponse creates a response to parse from UpdateIPSegment response
func CreateUpdateIPSegmentResponse() (response *UpdateIPSegmentResponse) {
	response = &UpdateIPSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
