package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SpeechByCombination invokes the iot.SpeechByCombination API synchronously
func (client *Client) SpeechByCombination(request *SpeechByCombinationRequest) (response *SpeechByCombinationResponse, err error) {
	response = CreateSpeechByCombinationResponse()
	err = client.DoAction(request, response)
	return
}

// SpeechByCombinationWithChan invokes the iot.SpeechByCombination API asynchronously
func (client *Client) SpeechByCombinationWithChan(request *SpeechByCombinationRequest) (<-chan *SpeechByCombinationResponse, <-chan error) {
	responseChan := make(chan *SpeechByCombinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SpeechByCombination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SpeechByCombinationWithCallback invokes the iot.SpeechByCombination API asynchronously
func (client *Client) SpeechByCombinationWithCallback(request *SpeechByCombinationRequest, callback func(response *SpeechByCombinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SpeechByCombinationResponse
		var err error
		defer close(result)
		response, err = client.SpeechByCombination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SpeechByCombinationRequest is the request struct for api SpeechByCombination
type SpeechByCombinationRequest struct {
	*requests.RpcRequest
	SpeechId        string    `position:"Body" name:"SpeechId"`
	AudioFormat     string    `position:"Body" name:"AudioFormat"`
	IotId           string    `position:"Body" name:"IotId"`
	CombinationList *[]string `position:"Body" name:"CombinationList"  type:"Repeated"`
	IotInstanceId   string    `position:"Body" name:"IotInstanceId"`
	ProductKey      string    `position:"Body" name:"ProductKey"`
	ApiProduct      string    `position:"Body" name:"ApiProduct"`
	ApiRevision     string    `position:"Body" name:"ApiRevision"`
	DeviceName      string    `position:"Body" name:"DeviceName"`
}

// SpeechByCombinationResponse is the response struct for api SpeechByCombination
type SpeechByCombinationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateSpeechByCombinationRequest creates a request to invoke SpeechByCombination API
func CreateSpeechByCombinationRequest() (request *SpeechByCombinationRequest) {
	request = &SpeechByCombinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "SpeechByCombination", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSpeechByCombinationResponse creates a response to parse from SpeechByCombination response
func CreateSpeechByCombinationResponse() (response *SpeechByCombinationResponse) {
	response = &SpeechByCombinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
