package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryThingModelExtendConfigPublished invokes the iot.QueryThingModelExtendConfigPublished API synchronously
func (client *Client) QueryThingModelExtendConfigPublished(request *QueryThingModelExtendConfigPublishedRequest) (response *QueryThingModelExtendConfigPublishedResponse, err error) {
	response = CreateQueryThingModelExtendConfigPublishedResponse()
	err = client.DoAction(request, response)
	return
}

// QueryThingModelExtendConfigPublishedWithChan invokes the iot.QueryThingModelExtendConfigPublished API asynchronously
func (client *Client) QueryThingModelExtendConfigPublishedWithChan(request *QueryThingModelExtendConfigPublishedRequest) (<-chan *QueryThingModelExtendConfigPublishedResponse, <-chan error) {
	responseChan := make(chan *QueryThingModelExtendConfigPublishedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryThingModelExtendConfigPublished(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryThingModelExtendConfigPublishedWithCallback invokes the iot.QueryThingModelExtendConfigPublished API asynchronously
func (client *Client) QueryThingModelExtendConfigPublishedWithCallback(request *QueryThingModelExtendConfigPublishedRequest, callback func(response *QueryThingModelExtendConfigPublishedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryThingModelExtendConfigPublishedResponse
		var err error
		defer close(result)
		response, err = client.QueryThingModelExtendConfigPublished(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryThingModelExtendConfigPublishedRequest is the request struct for api QueryThingModelExtendConfigPublished
type QueryThingModelExtendConfigPublishedRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	ModelVersion      string `position:"Query" name:"ModelVersion"`
	FunctionBlockId   string `position:"Query" name:"FunctionBlockId"`
}

// QueryThingModelExtendConfigPublishedResponse is the response struct for api QueryThingModelExtendConfigPublished
type QueryThingModelExtendConfigPublishedResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryThingModelExtendConfigPublishedRequest creates a request to invoke QueryThingModelExtendConfigPublished API
func CreateQueryThingModelExtendConfigPublishedRequest() (request *QueryThingModelExtendConfigPublishedRequest) {
	request = &QueryThingModelExtendConfigPublishedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryThingModelExtendConfigPublished", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryThingModelExtendConfigPublishedResponse creates a response to parse from QueryThingModelExtendConfigPublished response
func CreateQueryThingModelExtendConfigPublishedResponse() (response *QueryThingModelExtendConfigPublishedResponse) {
	response = &QueryThingModelExtendConfigPublishedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
