package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOTAUnfinishedTaskByDevice invokes the iot.ListOTAUnfinishedTaskByDevice API synchronously
func (client *Client) ListOTAUnfinishedTaskByDevice(request *ListOTAUnfinishedTaskByDeviceRequest) (response *ListOTAUnfinishedTaskByDeviceResponse, err error) {
	response = CreateListOTAUnfinishedTaskByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListOTAUnfinishedTaskByDeviceWithChan invokes the iot.ListOTAUnfinishedTaskByDevice API asynchronously
func (client *Client) ListOTAUnfinishedTaskByDeviceWithChan(request *ListOTAUnfinishedTaskByDeviceRequest) (<-chan *ListOTAUnfinishedTaskByDeviceResponse, <-chan error) {
	responseChan := make(chan *ListOTAUnfinishedTaskByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOTAUnfinishedTaskByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOTAUnfinishedTaskByDeviceWithCallback invokes the iot.ListOTAUnfinishedTaskByDevice API asynchronously
func (client *Client) ListOTAUnfinishedTaskByDeviceWithCallback(request *ListOTAUnfinishedTaskByDeviceRequest, callback func(response *ListOTAUnfinishedTaskByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOTAUnfinishedTaskByDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListOTAUnfinishedTaskByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOTAUnfinishedTaskByDeviceRequest is the request struct for api ListOTAUnfinishedTaskByDevice
type ListOTAUnfinishedTaskByDeviceRequest struct {
	*requests.RpcRequest
	TaskStatus    string `position:"Query" name:"TaskStatus"`
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ModuleName    string `position:"Query" name:"ModuleName"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// ListOTAUnfinishedTaskByDeviceResponse is the response struct for api ListOTAUnfinishedTaskByDevice
type ListOTAUnfinishedTaskByDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string                              `json:"RequestId" xml:"RequestId"`
	Success      bool                                `json:"Success" xml:"Success"`
	Code         string                              `json:"Code" xml:"Code"`
	ErrorMessage string                              `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInListOTAUnfinishedTaskByDevice `json:"Data" xml:"Data"`
}

// CreateListOTAUnfinishedTaskByDeviceRequest creates a request to invoke ListOTAUnfinishedTaskByDevice API
func CreateListOTAUnfinishedTaskByDeviceRequest() (request *ListOTAUnfinishedTaskByDeviceRequest) {
	request = &ListOTAUnfinishedTaskByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListOTAUnfinishedTaskByDevice", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOTAUnfinishedTaskByDeviceResponse creates a response to parse from ListOTAUnfinishedTaskByDevice response
func CreateListOTAUnfinishedTaskByDeviceResponse() (response *ListOTAUnfinishedTaskByDeviceResponse) {
	response = &ListOTAUnfinishedTaskByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
