package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AnalyzeChestVessel invokes the imageprocess.AnalyzeChestVessel API synchronously
func (client *Client) AnalyzeChestVessel(request *AnalyzeChestVesselRequest) (response *AnalyzeChestVesselResponse, err error) {
	response = CreateAnalyzeChestVesselResponse()
	err = client.DoAction(request, response)
	return
}

// AnalyzeChestVesselWithChan invokes the imageprocess.AnalyzeChestVessel API asynchronously
func (client *Client) AnalyzeChestVesselWithChan(request *AnalyzeChestVesselRequest) (<-chan *AnalyzeChestVesselResponse, <-chan error) {
	responseChan := make(chan *AnalyzeChestVesselResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AnalyzeChestVessel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AnalyzeChestVesselWithCallback invokes the imageprocess.AnalyzeChestVessel API asynchronously
func (client *Client) AnalyzeChestVesselWithCallback(request *AnalyzeChestVesselRequest, callback func(response *AnalyzeChestVesselResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AnalyzeChestVesselResponse
		var err error
		defer close(result)
		response, err = client.AnalyzeChestVessel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AnalyzeChestVesselRequest is the request struct for api AnalyzeChestVessel
type AnalyzeChestVesselRequest struct {
	*requests.RpcRequest
	DataSourceType string                       `position:"Body" name:"DataSourceType"`
	OrgName        string                       `position:"Body" name:"OrgName"`
	DataFormat     string                       `position:"Body" name:"DataFormat"`
	URLList        *[]AnalyzeChestVesselURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId          string                       `position:"Body" name:"OrgId"`
	Async          requests.Boolean             `position:"Body" name:"Async"`
}

// AnalyzeChestVesselURLList is a repeated param struct in AnalyzeChestVesselRequest
type AnalyzeChestVesselURLList struct {
	URL string `name:"URL"`
}

// AnalyzeChestVesselResponse is the response struct for api AnalyzeChestVessel
type AnalyzeChestVesselResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAnalyzeChestVesselRequest creates a request to invoke AnalyzeChestVessel API
func CreateAnalyzeChestVesselRequest() (request *AnalyzeChestVesselRequest) {
	request = &AnalyzeChestVesselRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "AnalyzeChestVessel", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAnalyzeChestVesselResponse creates a response to parse from AnalyzeChestVessel response
func CreateAnalyzeChestVesselResponse() (response *AnalyzeChestVesselResponse) {
	response = &AnalyzeChestVesselResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
