package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImitatePhotoStyle invokes the imageenhan.ImitatePhotoStyle API synchronously
func (client *Client) ImitatePhotoStyle(request *ImitatePhotoStyleRequest) (response *ImitatePhotoStyleResponse, err error) {
	response = CreateImitatePhotoStyleResponse()
	err = client.DoAction(request, response)
	return
}

// ImitatePhotoStyleWithChan invokes the imageenhan.ImitatePhotoStyle API asynchronously
func (client *Client) ImitatePhotoStyleWithChan(request *ImitatePhotoStyleRequest) (<-chan *ImitatePhotoStyleResponse, <-chan error) {
	responseChan := make(chan *ImitatePhotoStyleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImitatePhotoStyle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImitatePhotoStyleWithCallback invokes the imageenhan.ImitatePhotoStyle API asynchronously
func (client *Client) ImitatePhotoStyleWithCallback(request *ImitatePhotoStyleRequest, callback func(response *ImitatePhotoStyleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImitatePhotoStyleResponse
		var err error
		defer close(result)
		response, err = client.ImitatePhotoStyle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImitatePhotoStyleRequest is the request struct for api ImitatePhotoStyle
type ImitatePhotoStyleRequest struct {
	*requests.RpcRequest
	StyleUrl string `position:"Body" name:"StyleUrl"`
	ImageURL string `position:"Body" name:"ImageURL"`
}

// ImitatePhotoStyleResponse is the response struct for api ImitatePhotoStyle
type ImitatePhotoStyleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateImitatePhotoStyleRequest creates a request to invoke ImitatePhotoStyle API
func CreateImitatePhotoStyleRequest() (request *ImitatePhotoStyleRequest) {
	request = &ImitatePhotoStyleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "ImitatePhotoStyle", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImitatePhotoStyleResponse creates a response to parse from ImitatePhotoStyle response
func CreateImitatePhotoStyleResponse() (response *ImitatePhotoStyleResponse) {
	response = &ImitatePhotoStyleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
