package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserDepartments invokes the idrsservice.CreateUserDepartments API synchronously
func (client *Client) CreateUserDepartments(request *CreateUserDepartmentsRequest) (response *CreateUserDepartmentsResponse, err error) {
	response = CreateCreateUserDepartmentsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserDepartmentsWithChan invokes the idrsservice.CreateUserDepartments API asynchronously
func (client *Client) CreateUserDepartmentsWithChan(request *CreateUserDepartmentsRequest) (<-chan *CreateUserDepartmentsResponse, <-chan error) {
	responseChan := make(chan *CreateUserDepartmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserDepartments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserDepartmentsWithCallback invokes the idrsservice.CreateUserDepartments API asynchronously
func (client *Client) CreateUserDepartmentsWithCallback(request *CreateUserDepartmentsRequest, callback func(response *CreateUserDepartmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserDepartmentsResponse
		var err error
		defer close(result)
		response, err = client.CreateUserDepartments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserDepartmentsRequest is the request struct for api CreateUserDepartments
type CreateUserDepartmentsRequest struct {
	*requests.RpcRequest
	DepartmentId *[]string `position:"Query" name:"DepartmentId"  type:"Repeated"`
	UserId       *[]string `position:"Query" name:"UserId"  type:"Repeated"`
}

// CreateUserDepartmentsResponse is the response struct for api CreateUserDepartments
type CreateUserDepartmentsResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"Code" xml:"Code"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateCreateUserDepartmentsRequest creates a request to invoke CreateUserDepartments API
func CreateCreateUserDepartmentsRequest() (request *CreateUserDepartmentsRequest) {
	request = &CreateUserDepartmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "CreateUserDepartments", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateUserDepartmentsResponse creates a response to parse from CreateUserDepartments response
func CreateCreateUserDepartmentsResponse() (response *CreateUserDepartmentsResponse) {
	response = &CreateUserDepartmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
