package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAddVideoDnaResults invokes the green.GetAddVideoDnaResults API synchronously
func (client *Client) GetAddVideoDnaResults(request *GetAddVideoDnaResultsRequest) (response *GetAddVideoDnaResultsResponse, err error) {
	response = CreateGetAddVideoDnaResultsResponse()
	err = client.DoAction(request, response)
	return
}

// GetAddVideoDnaResultsWithChan invokes the green.GetAddVideoDnaResults API asynchronously
func (client *Client) GetAddVideoDnaResultsWithChan(request *GetAddVideoDnaResultsRequest) (<-chan *GetAddVideoDnaResultsResponse, <-chan error) {
	responseChan := make(chan *GetAddVideoDnaResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAddVideoDnaResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAddVideoDnaResultsWithCallback invokes the green.GetAddVideoDnaResults API asynchronously
func (client *Client) GetAddVideoDnaResultsWithCallback(request *GetAddVideoDnaResultsRequest, callback func(response *GetAddVideoDnaResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAddVideoDnaResultsResponse
		var err error
		defer close(result)
		response, err = client.GetAddVideoDnaResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAddVideoDnaResultsRequest is the request struct for api GetAddVideoDnaResults
type GetAddVideoDnaResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// GetAddVideoDnaResultsResponse is the response struct for api GetAddVideoDnaResults
type GetAddVideoDnaResultsResponse struct {
	*responses.BaseResponse
}

// CreateGetAddVideoDnaResultsRequest creates a request to invoke GetAddVideoDnaResults API
func CreateGetAddVideoDnaResultsRequest() (request *GetAddVideoDnaResultsRequest) {
	request = &GetAddVideoDnaResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "GetAddVideoDnaResults", "/green/video/dna/add/results", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAddVideoDnaResultsResponse creates a response to parse from GetAddVideoDnaResults response
func CreateGetAddVideoDnaResultsResponse() (response *GetAddVideoDnaResultsResponse) {
	response = &GetAddVideoDnaResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
