package geoip

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGeoipInstanceDataUrl invokes the geoip.DescribeGeoipInstanceDataUrl API synchronously
func (client *Client) DescribeGeoipInstanceDataUrl(request *DescribeGeoipInstanceDataUrlRequest) (response *DescribeGeoipInstanceDataUrlResponse, err error) {
	response = CreateDescribeGeoipInstanceDataUrlResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGeoipInstanceDataUrlWithChan invokes the geoip.DescribeGeoipInstanceDataUrl API asynchronously
func (client *Client) DescribeGeoipInstanceDataUrlWithChan(request *DescribeGeoipInstanceDataUrlRequest) (<-chan *DescribeGeoipInstanceDataUrlResponse, <-chan error) {
	responseChan := make(chan *DescribeGeoipInstanceDataUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGeoipInstanceDataUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGeoipInstanceDataUrlWithCallback invokes the geoip.DescribeGeoipInstanceDataUrl API asynchronously
func (client *Client) DescribeGeoipInstanceDataUrlWithCallback(request *DescribeGeoipInstanceDataUrlRequest, callback func(response *DescribeGeoipInstanceDataUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGeoipInstanceDataUrlResponse
		var err error
		defer close(result)
		response, err = client.DescribeGeoipInstanceDataUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGeoipInstanceDataUrlRequest is the request struct for api DescribeGeoipInstanceDataUrl
type DescribeGeoipInstanceDataUrlRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	DataType     string `position:"Query" name:"DataType"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeGeoipInstanceDataUrlResponse is the response struct for api DescribeGeoipInstanceDataUrl
type DescribeGeoipInstanceDataUrlResponse struct {
	*responses.BaseResponse
	FixedDomainDownloadUrl string `json:"FixedDomainDownloadUrl" xml:"FixedDomainDownloadUrl"`
	RequestId              string `json:"RequestId" xml:"RequestId"`
	DownloadUrl            string `json:"DownloadUrl" xml:"DownloadUrl"`
}

// CreateDescribeGeoipInstanceDataUrlRequest creates a request to invoke DescribeGeoipInstanceDataUrl API
func CreateDescribeGeoipInstanceDataUrlRequest() (request *DescribeGeoipInstanceDataUrlRequest) {
	request = &DescribeGeoipInstanceDataUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("geoip", "2020-01-01", "DescribeGeoipInstanceDataUrl", "geoip", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGeoipInstanceDataUrlResponse creates a response to parse from DescribeGeoipInstanceDataUrl response
func CreateDescribeGeoipInstanceDataUrlResponse() (response *DescribeGeoipInstanceDataUrlResponse) {
	response = &DescribeGeoipInstanceDataUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
