package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNetwork invokes the ens.DeleteNetwork API synchronously
func (client *Client) DeleteNetwork(request *DeleteNetworkRequest) (response *DeleteNetworkResponse, err error) {
	response = CreateDeleteNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNetworkWithChan invokes the ens.DeleteNetwork API asynchronously
func (client *Client) DeleteNetworkWithChan(request *DeleteNetworkRequest) (<-chan *DeleteNetworkResponse, <-chan error) {
	responseChan := make(chan *DeleteNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNetworkWithCallback invokes the ens.DeleteNetwork API asynchronously
func (client *Client) DeleteNetworkWithCallback(request *DeleteNetworkRequest, callback func(response *DeleteNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNetworkResponse
		var err error
		defer close(result)
		response, err = client.DeleteNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNetworkRequest is the request struct for api DeleteNetwork
type DeleteNetworkRequest struct {
	*requests.RpcRequest
	NetworkId string `position:"Query" name:"NetworkId"`
}

// DeleteNetworkResponse is the response struct for api DeleteNetwork
type DeleteNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNetworkRequest creates a request to invoke DeleteNetwork API
func CreateDeleteNetworkRequest() (request *DeleteNetworkRequest) {
	request = &DeleteNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteNetwork", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNetworkResponse creates a response to parse from DeleteNetwork response
func CreateDeleteNetworkResponse() (response *DeleteNetworkResponse) {
	response = &DeleteNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
