package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVmAndSaveStock invokes the ens.CreateVmAndSaveStock API synchronously
func (client *Client) CreateVmAndSaveStock(request *CreateVmAndSaveStockRequest) (response *CreateVmAndSaveStockResponse, err error) {
	response = CreateCreateVmAndSaveStockResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVmAndSaveStockWithChan invokes the ens.CreateVmAndSaveStock API asynchronously
func (client *Client) CreateVmAndSaveStockWithChan(request *CreateVmAndSaveStockRequest) (<-chan *CreateVmAndSaveStockResponse, <-chan error) {
	responseChan := make(chan *CreateVmAndSaveStockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVmAndSaveStock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVmAndSaveStockWithCallback invokes the ens.CreateVmAndSaveStock API asynchronously
func (client *Client) CreateVmAndSaveStockWithCallback(request *CreateVmAndSaveStockRequest, callback func(response *CreateVmAndSaveStockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVmAndSaveStockResponse
		var err error
		defer close(result)
		response, err = client.CreateVmAndSaveStock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVmAndSaveStockRequest is the request struct for api CreateVmAndSaveStock
type CreateVmAndSaveStockRequest struct {
	*requests.RpcRequest
	GroupUuid         string           `position:"Query" name:"GroupUuid"`
	ResourceAttribute string           `position:"Body" name:"ResourceAttribute"`
	AliUid            requests.Integer `position:"Query" name:"AliUid"`
	Tenant            string           `position:"Query" name:"Tenant"`
	WorkloadUuid      string           `position:"Query" name:"WorkloadUuid"`
}

// CreateVmAndSaveStockResponse is the response struct for api CreateVmAndSaveStock
type CreateVmAndSaveStockResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Msg       string `json:"Msg" xml:"Msg"`
	Desc      string `json:"Desc" xml:"Desc"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateVmAndSaveStockRequest creates a request to invoke CreateVmAndSaveStock API
func CreateCreateVmAndSaveStockRequest() (request *CreateVmAndSaveStockRequest) {
	request = &CreateVmAndSaveStockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateVmAndSaveStock", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVmAndSaveStockResponse creates a response to parse from CreateVmAndSaveStock response
func CreateCreateVmAndSaveStockResponse() (response *CreateVmAndSaveStockResponse) {
	response = &CreateVmAndSaveStockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
